/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.input.ProcessingInputTracker;
import mod.chiselsandbits.network.packets.ModPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class InputTrackerStatusUpdatePacket
extends ModPacket {
    private boolean isLeftMouse;
    private boolean started;

    public InputTrackerStatusUpdatePacket(FriendlyByteBuf buffer) {
        this.readPayload(buffer);
    }

    public InputTrackerStatusUpdatePacket(boolean isLeftMouse, boolean started) {
        this.isLeftMouse = isLeftMouse;
        this.started = started;
    }

    @Override
    public void writePayload(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isLeftMouse);
        buffer.writeBoolean(this.started);
    }

    @Override
    public void readPayload(FriendlyByteBuf buffer) {
        this.isLeftMouse = buffer.readBoolean();
        this.started = buffer.readBoolean();
    }

    @Override
    public void server(ServerPlayer playerEntity) {
        if (this.isLeftMouse) {
            if (this.started) {
                ProcessingInputTracker.getInstance().onStartedLeftClicking((Player)playerEntity);
            } else {
                ProcessingInputTracker.getInstance().onStoppedLeftClicking((Player)playerEntity);
            }
        } else if (this.started) {
            ProcessingInputTracker.getInstance().onStartedRightClicking((Player)playerEntity);
        } else {
            ProcessingInputTracker.getInstance().onStoppedRightClicking((Player)playerEntity);
        }
    }
}

