/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.shaded.net.jpountz.lz4.LZ4FrameInputStream;
import mod.chiselsandbits.shaded.net.jpountz.lz4.LZ4FrameOutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LZ4DataCompressionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static CompoundTag compress(Consumer<CompoundTag> uncompressedBuilder) {
        CompoundTag result = new CompoundTag();
        LZ4DataCompressionUtils.compress(result, uncompressedBuilder);
        return result;
    }

    public static void compress(CompoundTag compoundTag, Consumer<CompoundTag> uncompressedBuilder) {
        CompoundTag uncompressedData = new CompoundTag();
        uncompressedBuilder.accept(uncompressedData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            LZ4FrameOutputStream lz4Stream = new LZ4FrameOutputStream(outputStream);
            DataOutputStream dataOutput = new DataOutputStream(lz4Stream);
            NbtIo.m_128941_((CompoundTag)uncompressedData, (DataOutput)dataOutput);
            ((OutputStream)lz4Stream).close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to compress data. Uncompressed data will be stored.", (Throwable)e);
            compoundTag.m_128379_("compressed", false);
            compoundTag.m_128365_("data", (Tag)uncompressedData);
            return;
        }
        byte[] compressedData = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close compression stream!", (Throwable)e);
        }
        compoundTag.m_128379_("compressed", true);
        compoundTag.m_128382_("data", compressedData);
    }

    public static void decompress(CompoundTag input, Consumer<CompoundTag> uncompressedConsumer) {
        CompoundTag uncompressedData;
        if (!input.m_128441_("compressed") || !input.m_128441_("data")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            uncompressedConsumer.accept(input);
            return;
        }
        if (!input.m_128471_("compressed")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            uncompressedConsumer.accept(input.m_128469_("data"));
            return;
        }
        byte[] compressedData = input.m_128463_("data");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);
        try {
            LZ4FrameInputStream lz4FrameInputStream = new LZ4FrameInputStream(byteArrayInputStream);
            DataInputStream dataInput = new DataInputStream(lz4FrameInputStream);
            uncompressedData = NbtIo.m_128928_((DataInput)dataInput);
        }
        catch (IOException e) {
            LOGGER.error("Failed to decompress data. Uncompressed data will be loaded.", (Throwable)e);
            return;
        }
        uncompressedConsumer.accept(uncompressedData);
    }

    public static <P> P decompress(CompoundTag input, Function<CompoundTag, P> uncompressedConsumer) {
        if (!input.m_128441_("compressed") || !input.m_128441_("data")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            return uncompressedConsumer.apply(input);
        }
        if (!input.m_128471_("compressed")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            return uncompressedConsumer.apply(input.m_128469_("data"));
        }
        byte[] compressedData = input.m_128463_("data");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);
        CompoundTag uncompressedData = input;
        try {
            LZ4FrameInputStream lz4FrameInputStream = new LZ4FrameInputStream(byteArrayInputStream);
            DataInputStream dataInput = new DataInputStream(lz4FrameInputStream);
            uncompressedData = NbtIo.m_128928_((DataInput)dataInput);
        }
        catch (IOException e) {
            LOGGER.error("Failed to decompress data. Uncompressed data will be loaded.", (Throwable)e);
        }
        return uncompressedConsumer.apply(uncompressedData);
    }
}

