/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import com.simibubi.create.foundation.utility.Lang;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class DeployerFakePlayer
extends FakePlayer {
    private static final Connection NETWORK_MANAGER = new Connection(PacketFlow.CLIENTBOUND);
    public static final GameProfile DEPLOYER_PROFILE = new GameProfile(UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d"), "Deployer");
    Pair<BlockPos, Float> blockBreakingProgress;
    ItemStack spawnedItemEffects;
    public boolean placedTracks;
    public boolean onMinecartContraption;

    public DeployerFakePlayer(ServerLevel world) {
        super(world, DEPLOYER_PROFILE);
        this.f_8906_ = new FakePlayNetHandler(world.m_142572_(), (ServerPlayer)this);
    }

    public OptionalInt m_5893_(MenuProvider container) {
        return OptionalInt.empty();
    }

    public Component m_5446_() {
        return Lang.translateDirect("block.deployer.damage_source_name", new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_20236_(Pose poseIn) {
        return 0.0f;
    }

    public Vec3 m_20182_() {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public float m_36333_() {
        return 0.015625f;
    }

    public boolean m_36391_(boolean ignoreHunger) {
        return false;
    }

    public ItemStack m_5584_(Level world, ItemStack stack) {
        stack.m_41774_(1);
        return stack;
    }

    @SubscribeEvent
    public static void deployerHasEyesOnHisFeet(EntityEvent.Size event) {
        if (event.getEntity() instanceof DeployerFakePlayer) {
            event.setNewEyeHeight(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void deployerCollectsDropsFromKilledEntities(LivingDropsEvent event) {
        if (!(event.getSource() instanceof EntityDamageSource)) {
            return;
        }
        EntityDamageSource source = (EntityDamageSource)event.getSource();
        Entity trueSource = source.m_7639_();
        if (trueSource != null && trueSource instanceof DeployerFakePlayer) {
            DeployerFakePlayer fakePlayer = (DeployerFakePlayer)trueSource;
            event.getDrops().forEach(stack -> fakePlayer.m_150109_().m_150079_(stack.m_32055_()));
            event.setCanceled(true);
        }
    }

    protected void m_147218_(ItemStack p_147219_) {
    }

    public void m_142687_(Entity.RemovalReason p_150097_) {
        if (this.blockBreakingProgress != null && !this.f_19853_.f_46443_) {
            this.f_19853_.m_6801_(this.m_142049_(), (BlockPos)this.blockBreakingProgress.getKey(), -1);
        }
        super.m_142687_(p_150097_);
    }

    @SubscribeEvent
    public static void deployerKillsDoNotSpawnXP(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() instanceof DeployerFakePlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void entitiesDontRetaliate(LivingSetAttackTargetEvent event) {
        if (!(event.getTarget() instanceof DeployerFakePlayer)) {
            return;
        }
        LivingEntity entityLiving = event.getEntityLiving();
        if (!(entityLiving instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entityLiving;
        CKinetics.DeployerAggroSetting setting = (CKinetics.DeployerAggroSetting)((Object)AllConfigs.SERVER.kinetics.ignoreDeployerAttacks.get());
        switch (setting) {
            case ALL: {
                mob.m_6710_(null);
                break;
            }
            case CREEPERS: {
                if (!(mob instanceof Creeper)) break;
                mob.m_6710_(null);
                break;
            }
        }
    }

    private static class FakePlayNetHandler
    extends ServerGamePacketListenerImpl {
        public FakePlayNetHandler(MinecraftServer server, ServerPlayer playerIn) {
            super(server, NETWORK_MANAGER, playerIn);
        }

        public void m_141995_(Packet<?> packetIn) {
        }

        public void m_9831_(Packet<?> packetIn, GenericFutureListener<? extends Future<? super Void>> futureListeners) {
        }
    }
}

