/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class DeployerItemHandler
implements IItemHandlerModifiable {
    private DeployerTileEntity te;
    private DeployerFakePlayer player;

    public DeployerItemHandler(DeployerTileEntity te) {
        this.te = te;
        this.player = te.player;
    }

    public int getSlots() {
        return 1 + this.te.overflowItems.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return slot >= this.te.overflowItems.size() ? this.getHeld() : this.te.overflowItems.get(slot);
    }

    public ItemStack getHeld() {
        if (this.player == null) {
            return ItemStack.f_41583_;
        }
        return this.player.m_21205_();
    }

    public void set(ItemStack stack) {
        if (this.player == null) {
            return;
        }
        if (this.te.m_58904_().f_46443_) {
            return;
        }
        this.player.m_21008_(InteractionHand.MAIN_HAND, stack);
        this.te.m_6596_();
        this.te.sendData();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot < this.te.overflowItems.size()) {
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack held = this.getHeld();
        if (held.m_41619_()) {
            if (!simulate) {
                this.set(stack);
            }
            return ItemStack.f_41583_;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)held, (ItemStack)stack)) {
            return stack;
        }
        int space = held.m_41741_() - held.m_41613_();
        ItemStack remainder = stack.m_41777_();
        ItemStack split = remainder.m_41620_(space);
        if (space == 0) {
            return stack;
        }
        if (!simulate) {
            held = held.m_41777_();
            held.m_41764_(held.m_41613_() + split.m_41613_());
            this.set(held);
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        if (slot < this.te.overflowItems.size()) {
            ItemStack itemStack = this.te.overflowItems.get(slot);
            int toExtract = Math.min(amount, itemStack.m_41613_());
            ItemStack extracted = simulate ? itemStack.m_41777_() : itemStack.m_41620_(toExtract);
            extracted.m_41764_(toExtract);
            if (!simulate && itemStack.m_41619_()) {
                this.te.overflowItems.remove(slot);
            }
            if (!simulate && !extracted.m_41619_()) {
                this.te.m_6596_();
            }
            return extracted;
        }
        ItemStack held = this.getHeld();
        if (amount == 0 || held.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.te.filtering.getFilter().m_41619_() && this.te.filtering.test(held)) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            return held.m_41777_().m_41620_(amount);
        }
        ItemStack toReturn = held.m_41620_(amount);
        this.te.m_6596_();
        this.te.sendData();
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return Math.min(this.getStackInSlot(slot).m_41741_(), 64);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        FilteringBehaviour filteringBehaviour = this.te.getBehaviour(FilteringBehaviour.TYPE);
        return filteringBehaviour == null || filteringBehaviour.test(stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < this.te.overflowItems.size()) {
            this.te.overflowItems.set(slot, stack);
            return;
        }
        this.set(stack);
    }
}

