/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.content.contraptions.components.tracks.ControllerRailBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CartAssemblerTileEntity
extends SmartTileEntity
implements IDisplayAssemblyExceptions {
    private static final int assemblyCooldown = 8;
    protected ScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate = 8;
    protected AssemblyException lastException;
    protected AbstractMinecart cartToAssemble;

    public CartAssemblerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksSinceMinecartUpdate < 8) {
            ++this.ticksSinceMinecartUpdate;
        }
        this.tryAssemble(this.cartToAssemble);
        this.cartToAssemble = null;
    }

    public void tryAssemble(AbstractMinecart cart) {
        if (cart == null) {
            return;
        }
        if (!this.isMinecartUpdateValid()) {
            return;
        }
        this.resetTicksSinceMinecartUpdate();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (!AllBlocks.CART_ASSEMBLER.has(state)) {
            return;
        }
        CartAssemblerBlock block = (CartAssemblerBlock)state.m_60734_();
        CartAssemblerBlock.CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
        if (action.shouldAssemble()) {
            this.assemble(this.f_58857_, this.f_58858_, cart);
        }
        if (action.shouldDisassemble()) {
            this.disassemble(this.f_58857_, this.f_58858_, cart);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE && cart.m_20184_().m_82553_() > 0.0078125) {
            Direction facing = cart.m_6374_();
            RailShape railShape = (RailShape)state.m_61143_(CartAssemblerBlock.RAIL_SHAPE);
            for (Direction d : Iterate.directionsInAxis(railShape == RailShape.EAST_WEST ? Direction.Axis.X : Direction.Axis.Z)) {
                if (!this.f_58857_.m_8055_(this.f_58858_.m_142300_(d)).m_60796_((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(d))) continue;
                facing = d.m_122424_();
            }
            float speed = block.getRailMaxSpeed(state, this.f_58857_, this.f_58858_, cart);
            cart.m_20334_((double)((float)facing.m_122429_() * speed), (double)((float)facing.m_122430_() * speed), (double)((float)facing.m_122431_() * speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
            Vec3i accelerationVector = ControllerRailBlock.getAccelerationVector((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().m_61124_(ControllerRailBlock.SHAPE, (Comparable)((RailShape)state.m_61143_(CartAssemblerBlock.RAIL_SHAPE)))).m_61124_((Property)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.m_61143_((Property)CartAssemblerBlock.BACKWARDS))));
            float speed = block.getRailMaxSpeed(state, this.f_58857_, this.f_58858_, cart);
            cart.m_20256_(Vec3.m_82528_((Vec3i)accelerationVector).m_82490_((double)speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE_BRAKE) {
            Vec3 diff = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82546_(cart.m_20182_());
            cart.m_20334_(diff.f_82479_ / 16.0, 0.0, diff.f_82481_ / 16.0);
        }
    }

    protected void assemble(Level world, BlockPos pos, AbstractMinecart cart) {
        if (!cart.m_20197_().isEmpty()) {
            return;
        }
        LazyOptional optional = cart.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        if (optional.isPresent() && ((MinecartController)optional.orElse(null)).isCoupledThroughContraption()) {
            return;
        }
        CartMovementMode mode = CartMovementMode.values()[this.movementMode.value];
        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos)) {
                return;
            }
            this.lastException = null;
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        boolean couplingFound = contraption.connectedCart != null;
        Direction initialOrientation = CartAssemblerBlock.getHorizontalDirection(this.m_58900_());
        if (couplingFound) {
            cart.m_6034_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f));
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.m_142049_(), contraption.connectedCart.m_142049_())) {
                return;
            }
        }
        contraption.removeBlocksFromWorld(world, BlockPos.f_121853_);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        if (couplingFound) {
            Vec3 diff = contraption.connectedCart.m_20182_().m_82546_(cart.m_20182_());
            initialOrientation = Direction.m_122364_((double)(Mth.m_14136_((double)diff.f_82481_, (double)diff.f_82479_) * 180.0 / Math.PI));
        }
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound) {
            entity.setCouplingId(cart.m_142081_());
        }
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        world.m_7967_((Entity)entity);
        entity.m_20329_((Entity)cart);
        if (cart instanceof MinecartFurnace) {
            CompoundTag nbt = cart.serializeNBT();
            nbt.m_128347_("PushZ", 0.0);
            nbt.m_128347_("PushX", 0.0);
            cart.deserializeNBT(nbt);
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    protected void disassemble(Level world, BlockPos pos, AbstractMinecart cart) {
        if (cart.m_20197_().isEmpty()) {
            return;
        }
        Entity entity = (Entity)cart.m_20197_().get(0);
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        UUID couplingId = contraption.getCouplingId();
        if (couplingId == null) {
            contraption.yaw = CartAssemblerBlock.getHorizontalDirection(this.m_58900_()).m_122435_();
            this.disassembleCart(cart);
            return;
        }
        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart) continue;
            BlockPos otherPos = minecartController.cart().m_142538_();
            BlockState blockState = world.m_8055_(otherPos);
            if (!AllBlocks.CART_ASSEMBLER.has(blockState)) {
                return;
            }
            if (CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble()) continue;
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            coupledCarts.get(current).removeConnection(current);
        }
        this.disassembleCart(cart);
    }

    protected void disassembleCart(AbstractMinecart cart) {
        cart.m_20153_();
        if (cart instanceof MinecartFurnace) {
            CompoundTag nbt = cart.serializeNBT();
            nbt.m_128347_("PushZ", cart.m_20184_().f_82479_);
            nbt.m_128347_("PushX", cart.m_20184_().f_82481_);
            cart.deserializeNBT(nbt);
        }
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.movementMode = new ScrollOptionBehaviour<CartMovementMode>(CartMovementMode.class, (Component)Lang.translateDirect("contraptions.cart_movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        behaviours.add(this.movementMode);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new CartAssemblerValueBoxTransform();
    }

    public void resetTicksSinceMinecartUpdate() {
        this.ticksSinceMinecartUpdate = 0;
    }

    public void assembleNextTick(AbstractMinecart cart) {
        if (this.cartToAssemble == null) {
            this.cartToAssemble = cart;
        }
    }

    public boolean isMinecartUpdateValid() {
        return this.ticksSinceMinecartUpdate >= 8;
    }

    public static enum CartMovementMode implements INamedIconOptions
    {
        ROTATE(AllIcons.I_CART_ROTATE),
        ROTATE_PAUSED(AllIcons.I_CART_ROTATE_PAUSED),
        ROTATION_LOCKED(AllIcons.I_CART_ROTATE_LOCKED);

        private String translationKey;
        private AllIcons icon;

        private CartMovementMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.cart_movement_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class CartAssemblerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public CartAssemblerValueBoxTransform() {
            super((BlockState state, Direction d) -> {
                if (d.m_122434_().m_122478_()) {
                    return false;
                }
                if (!state.m_61138_(CartAssemblerBlock.RAIL_SHAPE)) {
                    return false;
                }
                RailShape railShape = (RailShape)state.m_61143_(CartAssemblerBlock.RAIL_SHAPE);
                return d.m_122434_() == Direction.Axis.X == (railShape == RailShape.NORTH_SOUTH);
            });
        }

        @Override
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 8.0, 18.0);
        }
    }
}

