/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class BlazeBurnerTileEntity
extends SmartTileEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    public static final int INSERTION_THRESHOLD = 500;
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAnimation = LerpedFloat.linear();
    protected LerpedFloat headAngle = LerpedFloat.angular();
    protected boolean isCreative = false;
    protected boolean goggles = false;
    protected boolean hat;

    public BlazeBurnerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.headAngle.startWithValue((AngleHelper.horizontalAngle(state.m_61145_((Property)BlazeBurnerBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f);
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickAnimation() {
        boolean active;
        boolean bl = active = this.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && !player.m_20145_()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.m_20185_();
                    z = player.m_20189_();
                }
                double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
                double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
                target = AngleHelper.deg(-Mth.m_14136_((double)dz, (double)dx)) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff(this.headAngle.getValue(), target);
            this.headAngle.chase(target, 0.25, LerpedFloat.Chaser.exp(5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((AngleHelper.horizontalAngle(this.m_58900_().m_61145_((Property)BlazeBurnerBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f, 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp(0.25));
        this.headAnimation.tickChaser();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (!this.isCreative) {
            compound.m_128405_("fuelLevel", this.activeFuel.ordinal());
            compound.m_128405_("burnTimeRemaining", this.remainingBurnTime);
        } else {
            compound.m_128379_("isCreative", true);
        }
        if (this.goggles) {
            compound.m_128379_("Goggles", true);
        }
        if (this.hat) {
            compound.m_128379_("TrainHat", true);
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.m_128451_("fuelLevel")];
        this.remainingBurnTime = compound.m_128451_("burnTimeRemaining");
        this.isCreative = compound.m_128471_("isCreative");
        this.goggles = compound.m_128441_("Goggles");
        this.hat = compound.m_128441_("TrainHat");
        super.read(compound, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf(this.m_58900_());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)heat)));
        this.notifyUpdate();
    }

    protected boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.matches(itemStack)) {
            newBurnTime = 3200;
            newFuel = FuelType.SPECIAL;
        } else {
            newBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.matches(itemStack)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime <= 500) {
                newBurnTime += this.remainingBurnTime;
            } else if (forceOverflow && newFuel == FuelType.NORMAL) {
                newBurnTime = this.remainingBurnTime < 10000 ? Math.min(this.remainingBurnTime + newBurnTime, 10000) : this.remainingBurnTime;
            } else {
                return false;
            }
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.f_58857_.f_46443_) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11701_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.nextFloat() * 0.125f, 1.15f - this.f_58857_.f_46441_.nextFloat() * 0.25f);
        }
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.f_58857_.f_46443_) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(ItemStack stack) {
        return AllItems.CREATIVE_BLAZE_CAKE.isIn(stack);
    }

    public boolean isValidBlockAbove() {
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return AllBlocks.BASIN.has(blockState) || blockState.m_60734_() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11705_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.nextFloat() * 0.125f, 0.75f - this.f_58857_.f_46441_.nextFloat() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.f_58857_ == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        Random r = this.f_58857_.m_5822_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, r, 0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.nextInt(4) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60812_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()).m_83281_();
        if (empty || r.nextInt(8) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : r.nextDouble() * (double)0.0125f;
        Vec3 v2 = c.m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, r, 0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_().m_82490_((empty ? 0.25 : 0.5) + r.nextDouble() * 0.125)).m_82520_(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Random r = this.f_58857_.f_46441_;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly(Vec3.f_82478_, r, 0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_();
            Vec3 v = c.m_82549_(offset.m_82490_(0.5 + r.nextDouble() * 0.125)).m_82520_(0.0, 0.125, 0.0);
            Vec3 m = offset.m_82490_(0.03125);
            this.f_58857_.m_7106_((ParticleOptions)(soulFlame ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

