/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.contraptions.relays.gauge.StressGaugeTileEntity;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KineticStressDisplaySource
extends PercentOrProgressBarDisplaySource {
    @Override
    protected MutableComponent formatNumeric(DisplayLinkContext context, Float currentLevel) {
        int mode = this.getMode(context);
        if (mode == 1) {
            return super.formatNumeric(context, currentLevel);
        }
        LangBuilder builder = Lang.number(currentLevel.floatValue());
        if (context.getTargetTE() instanceof FlapDisplayTileEntity) {
            builder.space();
        }
        return builder.translate("generic.unit.stress", new Object[0]).component();
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().m_128451_("Mode");
    }

    @Override
    protected Float getProgress(DisplayLinkContext context) {
        BlockEntity blockEntity = context.getSourceTE();
        if (!(blockEntity instanceof StressGaugeTileEntity)) {
            return null;
        }
        StressGaugeTileEntity gaugeTile = (StressGaugeTileEntity)blockEntity;
        float capacity = gaugeTile.getNetworkCapacity();
        float stress = gaugeTile.getNetworkStress();
        if (capacity == 0.0f) {
            return Float.valueOf(0.0f);
        }
        return switch (this.getMode(context)) {
            case 0, 1 -> Float.valueOf(stress / capacity);
            case 2 -> Float.valueOf(stress);
            case 3 -> Float.valueOf(capacity);
            case 4 -> Float.valueOf(capacity - stress);
            default -> Float.valueOf(0.0f);
        };
    }

    @Override
    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    @Override
    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.kinetic_stress", "progress_bar", "percent", "current", "max", "remaining")).titled(Lang.translateDirect("display_source.kinetic_stress.display", new Object[0])), "Mode");
    }

    @Override
    protected String getTranslationKey() {
        return "kinetic_stress";
    }
}

