/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.inventories;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.block.inventories.BottomlessItemHandler;
import com.simibubi.create.content.logistics.block.inventories.CrateTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CreativeCrateTileEntity
extends CrateTileEntity {
    FilteringBehaviour filtering;
    LazyOptional<IItemHandler> itemHandler;
    private BottomlessItemHandler inv = new BottomlessItemHandler(this.filtering::getFilter);

    public CreativeCrateTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler = LazyOptional.of(() -> this.inv);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = this.createFilter();
        behaviours.add(this.filtering);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(){

            @Override
            protected void rotate(BlockState state, PoseStack ms) {
                TransformStack.cast((PoseStack)ms).rotateX(90.0);
            }

            @Override
            protected Vec3 getLocalOffset(BlockState state) {
                return new Vec3(0.5, 0.8125, 0.5);
            }

            @Override
            protected float getScale() {
                return super.getScale() * 1.5f;
            }
        });
    }
}

