/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.track.FakeTrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackBlockOutline;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.IMergeableTE;
import com.simibubi.create.foundation.tileEntity.RemoveTileEntityPacket;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class TrackTileEntity
extends SmartTileEntity
implements ITransformableTE,
IMergeableTE {
    Map<BlockPos, BezierConnection> connections = new HashMap<BlockPos, BezierConnection>();
    boolean cancelDrops;
    public Pair<ResourceKey<Level>, BlockPos> boundLocation;

    public TrackTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(100);
    }

    public Map<BlockPos, BezierConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_ && this.hasInteractableConnections()) {
            this.registerToCurveInteraction();
        }
    }

    @Override
    public void lazyTick() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void validateConnections() {
        HashSet<BlockPos> invalid = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            TrackTileEntity trackTE;
            BezierConnection bc;
            block10: {
                BlockPos key;
                block9: {
                    BlockEntity blockEntity;
                    key = entry.getKey();
                    if (!key.equals((Object)(bc = entry.getValue()).getKey()) || !this.f_58858_.equals(bc.tePositions.getFirst())) {
                        invalid.add(key);
                        continue;
                    }
                    BlockState blockState = this.f_58857_.m_8055_(key);
                    Block block = blockState.m_60734_();
                    if (block instanceof ITrackBlock) {
                        ITrackBlock trackBlock = (ITrackBlock)block;
                        if (!((Boolean)blockState.m_61143_((Property)TrackBlock.HAS_TE)).booleanValue()) {
                            for (Vec3 v : trackBlock.getTrackAxes((BlockGetter)this.f_58857_, key, blockState)) {
                                Vec3 bcEndAxis;
                                if (!(v.m_82554_(bcEndAxis = (Vec3)bc.axes.getSecond()) < 9.765625E-4) && !(v.m_82554_(bcEndAxis.m_82490_(-1.0)) < 9.765625E-4)) continue;
                                this.f_58857_.m_7731_(key, (BlockState)blockState.m_61124_((Property)TrackBlock.HAS_TE, (Comparable)Boolean.valueOf(true)), 3);
                            }
                        }
                    }
                    if (!((blockEntity = this.f_58857_.m_7702_(key)) instanceof TrackTileEntity)) break block9;
                    trackTE = (TrackTileEntity)blockEntity;
                    if (!blockEntity.m_58901_()) break block10;
                }
                invalid.add(key);
                continue;
            }
            if (trackTE.connections.containsKey(this.f_58858_)) continue;
            trackTE.addConnection(bc.secondary());
        }
        for (BlockPos blockPos : invalid) {
            this.removeConnection(blockPos);
        }
    }

    public void addConnection(BezierConnection connection) {
        this.connections.put(connection.getKey(), connection);
        this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 1);
        this.notifyUpdate();
        if (connection.isPrimary()) {
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void removeConnection(BlockPos target) {
        BezierConnection removed = this.connections.remove(target);
        this.notifyUpdate();
        if (removed != null) {
            this.manageFakeTracksAlong(removed, true);
        }
        if (!this.connections.isEmpty() || this.m_58900_().m_61145_(TrackBlock.SHAPE).orElse(TrackShape.NONE).isPortal()) {
            return;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        if (blockState.m_61138_((Property)TrackBlock.HAS_TE)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)TrackBlock.HAS_TE, (Comparable)Boolean.valueOf(false)));
        }
        AllPackets.channel.send(this.packetTarget(), (Object)new RemoveTileEntityPacket(this.f_58858_));
    }

    public void removeInboundConnections() {
        for (BezierConnection bezierConnection : this.connections.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(bezierConnection.getKey());
            if (!(blockEntity instanceof TrackTileEntity)) {
                return;
            }
            TrackTileEntity other = (TrackTileEntity)blockEntity;
            other.removeConnection((BlockPos)bezierConnection.tePositions.getFirst());
            if (!this.cancelDrops) {
                bezierConnection.spawnItems(this.f_58857_);
            }
            bezierConnection.spawnDestroyParticles(this.f_58857_);
        }
        AllPackets.channel.send(this.packetTarget(), (Object)new RemoveTileEntityPacket(this.f_58858_));
    }

    public void bind(ResourceKey<Level> boundDimension, BlockPos boundLocation) {
        this.boundLocation = Pair.of(boundDimension, boundLocation);
        this.m_6596_();
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        this.writeTurns(tag);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.writeTurns(tag);
        if (this.boundLocation == null) {
            return;
        }
        tag.m_128365_("BoundLocation", (Tag)NbtUtils.m_129224_((BlockPos)this.boundLocation.getSecond()));
        tag.m_128359_("BoundDimension", this.boundLocation.getFirst().m_135782_().toString());
    }

    private void writeTurns(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (BezierConnection bezierConnection : this.connections.values()) {
            listTag.add((Object)bezierConnection.write(this.f_58858_));
        }
        tag.m_128365_("Connections", (Tag)listTag);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.connections.clear();
        for (Tag t : tag.m_128437_("Connections", 10)) {
            if (!(t instanceof CompoundTag)) {
                return;
            }
            BezierConnection connection = new BezierConnection((CompoundTag)t, this.f_58858_);
            this.connections.put(connection.getKey(), connection);
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)this));
        if (this.hasInteractableConnections()) {
            this.registerToCurveInteraction();
        } else {
            this.removeFromCurveInteraction();
        }
        if (tag.m_128441_("BoundLocation")) {
            this.boundLocation = Pair.of(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("BoundDimension"))), NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BoundLocation")));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void accept(BlockEntity other) {
        if (other instanceof TrackTileEntity) {
            TrackTileEntity track = (TrackTileEntity)other;
            this.connections.putAll(track.connections);
        }
        this.validateConnections();
        this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 1);
    }

    public boolean hasInteractableConnections() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(StructureTransform transform) {
        if (transform.rotationAxis != Direction.Axis.Y) {
            return;
        }
        HashMap<BlockPos, BezierConnection> transformedConnections = new HashMap<BlockPos, BezierConnection>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            BezierConnection newConnection = entry.getValue();
            newConnection.normals.replace(transform::applyWithoutOffsetUncentered);
            newConnection.axes.replace(transform::applyWithoutOffsetUncentered);
            BlockPos diff = ((BlockPos)newConnection.tePositions.getSecond()).m_141950_((Vec3i)newConnection.tePositions.getFirst());
            newConnection.tePositions.setSecond(new BlockPos(Vec3.m_82512_((Vec3i)((Vec3i)newConnection.tePositions.getFirst())).m_82549_(transform.applyWithoutOffsetUncentered(Vec3.m_82528_((Vec3i)diff)))));
            Vec3 teVec = Vec3.m_82528_((Vec3i)this.f_58858_);
            Vec3 teCenterVec = teVec.m_82520_(0.5, 0.5, 0.5);
            Vec3 start = (Vec3)newConnection.starts.getFirst();
            Vec3 startToTE = start.m_82546_(teCenterVec);
            Vec3 endToStart = ((Vec3)newConnection.starts.getSecond()).m_82546_(start);
            startToTE = transform.applyWithoutOffsetUncentered(startToTE).m_82549_(teCenterVec);
            endToStart = transform.applyWithoutOffsetUncentered(endToStart).m_82549_(startToTE);
            newConnection.starts.setFirst(new TrackNodeLocation(startToTE).getLocation());
            newConnection.starts.setSecond(new TrackNodeLocation(endToStart).getLocation());
            BlockPos newTarget = newConnection.getKey();
            transformedConnections.put(newTarget, newConnection);
        }
        this.connections = transformedConnections;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.f_58857_.f_46443_) {
            this.removeFromCurveInteraction();
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (BezierConnection connection : this.connections.values()) {
            this.manageFakeTracksAlong(connection, true);
        }
        if (this.boundLocation != null && this.f_58857_ instanceof ServerLevel) {
            ServerLevel otherLevel = this.f_58857_.m_142572_().m_129880_(this.boundLocation.getFirst());
            if (otherLevel == null) {
                return;
            }
            if (AllBlocks.TRACK.has(otherLevel.m_8055_(this.boundLocation.getSecond()))) {
                otherLevel.m_46961_(this.boundLocation.getSecond(), false);
            }
        }
    }

    private void registerToCurveInteraction() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerToCurveInteractionUnsafe);
    }

    private void removeFromCurveInteraction() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::removeFromCurveInteractionUnsafe);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerToCurveInteractionUnsafe() {
        TrackBlockOutline.TRACKS_WITH_TURNS.get((LevelAccessor)this.f_58857_).put(this.f_58858_, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeFromCurveInteractionUnsafe() {
        TrackBlockOutline.TRACKS_WITH_TURNS.get((LevelAccessor)this.f_58857_).remove(this.f_58858_);
    }

    public void manageFakeTracksAlong(BezierConnection bc, boolean remove) {
        HashMap<Pair<Integer, Integer>, Double> yLevels = new HashMap<Pair<Integer, Integer>, Double>();
        BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
        Vec3 end1 = ((Vec3)bc.starts.getFirst()).m_82546_(Vec3.m_82528_((Vec3i)tePosition)).m_82520_(0.0, 0.1875, 0.0);
        Vec3 end2 = ((Vec3)bc.starts.getSecond()).m_82546_(Vec3.m_82528_((Vec3i)tePosition)).m_82520_(0.0, 0.1875, 0.0);
        Vec3 axis1 = (Vec3)bc.axes.getFirst();
        Vec3 axis2 = (Vec3)bc.axes.getSecond();
        double handleLength = bc.getHandleLength();
        Vec3 finish1 = axis1.m_82490_(handleLength).m_82549_(end1);
        Vec3 finish2 = axis2.m_82490_(handleLength).m_82549_(end2);
        Vec3 faceNormal1 = (Vec3)bc.normals.getFirst();
        Vec3 faceNormal2 = (Vec3)bc.normals.getSecond();
        int segCount = bc.getSegmentCount();
        float[] lut = bc.getStepLUT();
        for (int i = 0; i < segCount; ++i) {
            float t = i == segCount ? 1.0f : (float)i * lut[i] / (float)segCount;
            Vec3 result = VecHelper.bezier(end1, end2, finish1, finish2, t += 0.5f / (float)segCount);
            Vec3 derivative = VecHelper.bezierDerivative(end1, end2, finish1, finish2, t).m_82541_();
            Vec3 faceNormal = faceNormal1.equals((Object)faceNormal2) ? faceNormal1 : VecHelper.slerp(t, faceNormal1, faceNormal2);
            Vec3 normal = faceNormal.m_82537_(derivative).m_82541_();
            Vec3 below = result.m_82549_(faceNormal.m_82490_(-0.25));
            Vec3 rail1 = below.m_82549_(normal.m_82490_((double)0.05f));
            Vec3 rail2 = below.m_82546_(normal.m_82490_((double)0.05f));
            Vec3 railMiddle = rail1.m_82549_(rail2).m_82490_(0.5);
            for (Vec3 vec : new Vec3[]{railMiddle}) {
                BlockPos pos = new BlockPos(vec);
                Pair<Integer, Integer> key = Pair.of(pos.m_123341_(), pos.m_123343_());
                if (yLevels.containsKey(key) && !((Double)yLevels.get(key) > vec.f_82480_)) continue;
                yLevels.put(key, vec.f_82480_);
            }
        }
        for (Map.Entry entry : yLevels.entrySet()) {
            double yValue = (Double)entry.getValue();
            int floor = Mth.m_14107_((double)yValue);
            BlockPos targetPos = new BlockPos(((Integer)((Pair)entry.getKey()).getFirst()).intValue(), floor, ((Integer)((Pair)entry.getKey()).getSecond()).intValue());
            targetPos = targetPos.m_141952_((Vec3i)tePosition).m_6630_(1);
            BlockState stateAtPos = this.f_58857_.m_8055_(targetPos);
            boolean present = AllBlocks.FAKE_TRACK.has(stateAtPos);
            if (remove) {
                if (!present) continue;
                this.f_58857_.m_7471_(targetPos, false);
                continue;
            }
            FluidState fluidState = stateAtPos.m_60819_();
            if (!fluidState.m_76178_() && !fluidState.m_164512_((Fluid)Fluids.f_76193_)) continue;
            if (!present && stateAtPos.m_60767_().m_76336_()) {
                this.f_58857_.m_7731_(targetPos, ProperWaterloggedBlock.withWater((LevelAccessor)this.f_58857_, AllBlocks.FAKE_TRACK.getDefaultState(), targetPos), 3);
            }
            FakeTrackBlock.keepAlive((LevelAccessor)this.f_58857_, targetPos);
        }
    }
}

