/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.palettes;

import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.palettes.PaletteBlockPattern;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class PaletteBlockPartial<B extends Block> {
    public static final PaletteBlockPartial<StairBlock> STAIR = new Stairs();
    public static final PaletteBlockPartial<SlabBlock> SLAB = new Slab(false);
    public static final PaletteBlockPartial<SlabBlock> UNIQUE_SLAB = new Slab(true);
    public static final PaletteBlockPartial<WallBlock> WALL = new Wall();
    public static final PaletteBlockPartial<?>[] ALL_PARTIALS = new PaletteBlockPartial[]{STAIR, SLAB, WALL};
    public static final PaletteBlockPartial<?>[] FOR_POLISHED = new PaletteBlockPartial[]{STAIR, UNIQUE_SLAB, WALL};
    private String name;

    private PaletteBlockPartial(String name) {
        this.name = name;
    }

    @NonnullType
    public BlockBuilder<B, CreateRegistrate> create(String variantName, PaletteBlockPattern pattern, BlockEntry<? extends Block> block, AllPaletteStoneTypes variant) {
        String patternName = Lang.nonPluralId(pattern.createName(variantName));
        String blockName = patternName + "_" + this.name;
        BlockBuilder blockBuilder = (BlockBuilder)Create.REGISTRATE.block(blockName, p -> this.createBlock((Supplier<Block>)block)).blockstate((c, p) -> this.generateBlockState((DataGenContext<Block, B>)c, (RegistrateBlockstateProvider)p, variantName, pattern, (Supplier<? extends Block>)((Supplier<Block>)block))).recipe((c, p) -> this.createRecipes(variant, (BlockEntry<? extends Block>)((BlockEntry<Block>)block), (DataGenContext<Block, ? extends Block>)((DataGenContext<Block, Block>)c), (RegistrateRecipeProvider)p)).transform(b -> this.transformBlock((BlockBuilder<B, CreateRegistrate>)b, variantName, pattern));
        ItemBuilder itemBuilder = (ItemBuilder)blockBuilder.item().transform(b -> this.transformItem((ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>>)b, variantName, pattern));
        if (this.canRecycle()) {
            itemBuilder.tag(new TagKey[]{variant.materialTag});
        }
        return (BlockBuilder)itemBuilder.build();
    }

    protected ResourceLocation getTexture(String variantName, PaletteBlockPattern pattern, int index) {
        return PaletteBlockPattern.toLocation(variantName, pattern.getTexture(index));
    }

    protected BlockBuilder<B, CreateRegistrate> transformBlock(BlockBuilder<B, CreateRegistrate> builder, String variantName, PaletteBlockPattern pattern) {
        this.getBlockTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return (BlockBuilder)builder.transform(TagGen.pickaxeOnly());
    }

    protected ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> builder, String variantName, PaletteBlockPattern pattern) {
        this.getItemTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return builder;
    }

    protected boolean canRecycle() {
        return true;
    }

    protected abstract Iterable<TagKey<Block>> getBlockTags();

    protected abstract Iterable<TagKey<Item>> getItemTags();

    protected abstract B createBlock(Supplier<? extends Block> var1);

    protected abstract void createRecipes(AllPaletteStoneTypes var1, BlockEntry<? extends Block> var2, DataGenContext<Block, ? extends Block> var3, RegistrateRecipeProvider var4);

    protected abstract void generateBlockState(DataGenContext<Block, B> var1, RegistrateBlockstateProvider var2, String var3, PaletteBlockPattern var4, Supplier<? extends Block> var5);

    private static class Stairs
    extends PaletteBlockPartial<StairBlock> {
        public Stairs() {
            super("stairs");
        }

        @Override
        protected StairBlock createBlock(Supplier<? extends Block> block) {
            return new StairBlock(() -> ((Block)block.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, StairBlock> ctx, RegistrateBlockstateProvider prov, String variantName, PaletteBlockPattern pattern, Supplier<? extends Block> block) {
            prov.stairsBlock((StairBlock)ctx.get(), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.f_13030_);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return Arrays.asList(ItemTags.f_13138_);
        }

        @Override
        protected void createRecipes(AllPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            p.stairs(DataIngredient.items(patternBlock, (NonNullSupplier[])new NonNullSupplier[0]), () -> c.get(), c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), () -> c.get(), 1);
            p.stonecutting(DataIngredient.items(type.getBaseBlock(), (NonNullSupplier[])new NonNullSupplier[0]), () -> c.get(), 1);
        }
    }

    private static class Slab
    extends PaletteBlockPartial<SlabBlock> {
        private boolean customSide;

        public Slab(boolean customSide) {
            super("slab");
            this.customSide = customSide;
        }

        @Override
        protected SlabBlock createBlock(Supplier<? extends Block> block) {
            return new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected boolean canRecycle() {
            return false;
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String variantName, PaletteBlockPattern pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation sideTexture = this.customSide ? this.getTexture(variantName, pattern, 1) : mainTexture;
            ModelBuilder bottom = prov.models().slab(name, sideTexture, mainTexture, mainTexture);
            ModelBuilder top = prov.models().slabTop(name + "_top", sideTexture, mainTexture, mainTexture);
            Object doubleSlab = this.customSide ? prov.models().cubeColumn(name + "_double", sideTexture, mainTexture) : prov.models().getExistingFile(prov.modLoc(pattern.createName(variantName)));
            prov.slabBlock((SlabBlock)ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.f_13031_);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return Arrays.asList(ItemTags.f_13139_);
        }

        @Override
        protected void createRecipes(AllPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            p.slab(DataIngredient.items(patternBlock, (NonNullSupplier[])new NonNullSupplier[0]), () -> c.get(), c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), () -> c.get(), 2);
            p.stonecutting(DataIngredient.items(type.getBaseBlock(), (NonNullSupplier[])new NonNullSupplier[0]), () -> c.get(), 2);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)c.get()), (ItemLike[])new Block[0]);
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)patternBlock.get())).m_126184_((Ingredient)ingredient).m_126184_((Ingredient)ingredient).m_142284_("has_" + c.getName(), (CriterionTriggerInstance)ingredient.getCritereon(p)).m_176500_((Consumer)p, "create:" + c.getName() + "_recycling");
        }

        @Override
        protected BlockBuilder<SlabBlock, CreateRegistrate> transformBlock(BlockBuilder<SlabBlock, CreateRegistrate> builder, String variantName, PaletteBlockPattern pattern) {
            builder.loot((lt, block) -> lt.m_124165_((Block)block, RegistrateBlockLootTables.m_124290_((Block)block)));
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class Wall
    extends PaletteBlockPartial<WallBlock> {
        public Wall() {
            super("wall");
        }

        @Override
        protected WallBlock createBlock(Supplier<? extends Block> block) {
            return new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> builder, String variantName, PaletteBlockPattern pattern) {
            builder.model((c, p) -> p.wallInventory(c.getName(), this.getTexture(variantName, pattern, 0)));
            return super.transformItem(builder, variantName, pattern);
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String variantName, PaletteBlockPattern pattern, Supplier<? extends Block> block) {
            prov.wallBlock((WallBlock)ctx.get(), pattern.createName(variantName), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.f_13032_);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return Arrays.asList(ItemTags.f_13140_);
        }

        @Override
        protected void createRecipes(AllPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            p.stonecutting(DataIngredient.tag(type.materialTag), () -> c.get(), 1);
            p.stonecutting(DataIngredient.items(type.getBaseBlock(), (NonNullSupplier[])new NonNullSupplier[0]), () -> c.get(), 1);
            DataIngredient ingredient = DataIngredient.items(patternBlock, (NonNullSupplier[])new NonNullSupplier[0]);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)c.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)ingredient).m_142284_("has_" + p.safeName(ingredient), (CriterionTriggerInstance)ingredient.getCritereon(p)).m_142700_((Consumer)p, p.safeId(c.get()));
        }
    }
}

