/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.CreateRegistry;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.registries.ForgeRegistries;

public enum ContraptionMovementSetting {
    MOVABLE,
    NO_PICKUP,
    UNMOVABLE;

    private static final CreateRegistry<Block, Supplier<ContraptionMovementSetting>> SETTING_SUPPLIERS;

    public static void register(ResourceLocation block, Supplier<ContraptionMovementSetting> settingSupplier) {
        SETTING_SUPPLIERS.register((Block)block, settingSupplier);
    }

    public static void register(Block block, Supplier<ContraptionMovementSetting> settingSupplier) {
        SETTING_SUPPLIERS.register(block, settingSupplier);
    }

    @Nullable
    public static ContraptionMovementSetting get(Block block) {
        if (block instanceof IMovementSettingProvider) {
            IMovementSettingProvider provider = (IMovementSettingProvider)block;
            return provider.getContraptionMovementSetting();
        }
        Supplier<ContraptionMovementSetting> supplier = SETTING_SUPPLIERS.get(block);
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    public static boolean allAre(Collection<StructureTemplate.StructureBlockInfo> blocks, ContraptionMovementSetting are) {
        return blocks.stream().anyMatch(b -> ContraptionMovementSetting.get(b.f_74676_.m_60734_()) == are);
    }

    public static boolean isNoPickup(Collection<StructureTemplate.StructureBlockInfo> blocks) {
        return ContraptionMovementSetting.allAre(blocks, NO_PICKUP);
    }

    public static void registerDefaults() {
        ContraptionMovementSetting.register(Blocks.f_50085_, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.spawnerMovement.get())));
        ContraptionMovementSetting.register(Blocks.f_152491_, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.amethystMovement.get())));
        ContraptionMovementSetting.register(Blocks.f_50080_, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.obsidianMovement.get())));
        ContraptionMovementSetting.register(Blocks.f_50723_, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.obsidianMovement.get())));
        ContraptionMovementSetting.register(Blocks.f_50724_, () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.obsidianMovement.get())));
    }

    static {
        SETTING_SUPPLIERS = new CreateRegistry(ForgeRegistries.BLOCKS);
    }

    public static interface IMovementSettingProvider
    extends IForgeBlock {
        public ContraptionMovementSetting getContraptionMovementSetting();
    }
}

