/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class IMSBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.IntOption range = new Option.IntOption(() -> ((IMSBlockEntity)this).m_58899_(), "range", 15, 1, 30, 1, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private int bombsRemaining = 4;
    private IMSTargetingMode targetingMode = IMSTargetingMode.PLAYERS_AND_MOBS;
    private boolean updateBombCount = false;
    private int attackTime = this.getAttackInterval();

    public IMSBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.IMS_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_ && this.updateBombCount) {
            int mineCount = (Integer)state.m_61143_((Property)IMSBlock.MINES);
            if (mineCount - 1 >= 0 && mineCount <= 4) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)IMSBlock.MINES, (Comparable)Integer.valueOf(mineCount - 1)));
            }
            this.updateBombCount = false;
        }
        if (!this.isDisabled() && this.attackTime-- == 0) {
            this.attackTime = this.getAttackInterval();
            this.launchMine(level, pos);
        }
    }

    private void launchMine(Level level, BlockPos pos) {
        if (this.bombsRemaining > 0) {
            List players;
            List mobs;
            AABB area = new AABB(pos).m_82400_((double)((Integer)this.range.get()).intValue());
            LivingEntity target = null;
            if (!(this.targetingMode != IMSTargetingMode.MOBS && this.targetingMode != IMSTargetingMode.PLAYERS_AND_MOBS || (mobs = level.m_6443_(Monster.class, area, e -> !EntityUtils.isInvisible((LivingEntity)e) && this.canAttackEntity((LivingEntity)e))).isEmpty())) {
                target = (LivingEntity)mobs.get(0);
            }
            if (!(target != null || this.targetingMode != IMSTargetingMode.PLAYERS && this.targetingMode != IMSTargetingMode.PLAYERS_AND_MOBS || (players = level.m_6443_(Player.class, area, e -> !EntityUtils.isInvisible((LivingEntity)e) && this.canAttackEntity((LivingEntity)e))).isEmpty())) {
                target = (LivingEntity)players.get(0);
            }
            if (target != null) {
                double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 0.84375 : 0.0;
                double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 0.84375 : 0.0;
                int launchHeight = this.getLaunchHeight();
                double accelerationX = target.m_20185_() - (double)pos.m_123341_();
                double accelerationY = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 2.0f) - (double)pos.m_123342_() - (double)launchHeight;
                double accelerationZ = target.m_20189_() - (double)pos.m_123343_();
                level.m_7967_((Entity)new IMSBomb(level, (double)pos.m_123341_() + addToX, pos.m_123342_(), (double)pos.m_123343_() + addToZ, accelerationX, accelerationY, accelerationZ, launchHeight, this));
                if (!level.f_46443_) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
                this.m_6596_();
            }
        }
    }

    public boolean canAttackEntity(LivingEntity entity) {
        Player player;
        return entity != null && (!(entity instanceof Player) || (!this.isOwnedBy(player = (Player)entity) || !this.ignoresOwner()) && !player.m_7500_() && !player.m_5833_()) && !this.isAllowed((Entity)entity);
    }

    private int getLaunchHeight() {
        BlockState state;
        int height;
        for (height = 1; height <= 9 && ((state = this.m_58904_().m_8055_(this.m_58899_().m_6630_(height))) == null || state.m_60795_()); ++height) {
        }
        return height;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("bombsRemaining", this.bombsRemaining);
        tag.m_128405_("targetingOption", this.targetingMode.ordinal());
        tag.m_128379_("updateBombCount", this.updateBombCount);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bombsRemaining = tag.m_128451_("bombsRemaining");
        this.targetingMode = IMSTargetingMode.values()[tag.m_128451_("targetingOption")];
        this.updateBombCount = tag.m_128471_("updateBombCount");
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
        this.m_6596_();
    }

    public IMSTargetingMode getTargetingMode() {
        return this.targetingMode;
    }

    public void setTargetingMode(IMSTargetingMode targetingOption) {
        this.targetingMode = targetingOption;
        this.m_6596_();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.ignoreOwner};
    }

    public int getAttackInterval() {
        return this.isModuleEnabled(ModuleType.SPEED) ? 40 : 80;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public static enum IMSTargetingMode {
        PLAYERS,
        PLAYERS_AND_MOBS,
        MOBS;

    }
}

