/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SonicSecuritySystemBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE {
    private static final int PING_DELAY = 100;
    private static final int LISTEN_DELAY = 60;
    public static final int MAX_RANGE = 30;
    public static final int MAX_LINKED_BLOCKS = 30;
    private boolean emitsPings = true;
    private int pingCooldown = 100;
    public Option.IntOption signalLength = new Option.IntOption(() -> ((SonicSecuritySystemBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);
    public int powerCooldown = 0;
    public float radarRotationDegrees = 0.0f;
    public float oRadarRotationDegrees = 0.0f;
    private Set<BlockPos> linkedBlocks = new HashSet<BlockPos>();
    private boolean isActive = true;
    private boolean isRecording = false;
    private ArrayList<NoteWrapper> recordedNotes = new ArrayList();
    public boolean correctTuneWasPlayed = false;
    private boolean isListening = false;
    private int listeningTimer = 60;
    private int listenPos = 0;
    private boolean tracked = false;
    private boolean shutDown = false;

    public SonicSecuritySystemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.SONIC_SECURITY_SYSTEM.track(this);
            this.tracked = true;
        }
        if (!level.f_46443_) {
            if (!this.isActive()) {
                return;
            }
            if (this.correctTuneWasPlayed) {
                if (this.powerCooldown > 0) {
                    --this.powerCooldown;
                } else {
                    this.correctTuneWasPlayed = false;
                    level.m_46597_(this.f_58858_, (BlockState)level.m_8055_(this.f_58858_).m_61124_((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                    BlockUtils.updateIndirectNeighbors(level, this.f_58858_, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
                }
            }
            if (this.isListening) {
                if (this.listeningTimer > 0) {
                    --this.listeningTimer;
                    return;
                }
                this.stopListening();
            }
            if (!this.isLinkedToBlock()) {
                return;
            }
            if (this.pingCooldown > 0) {
                --this.pingCooldown;
            } else {
                ArrayList<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
                for (BlockPos blockPos : this.linkedBlocks) {
                    if (level.m_7702_(blockPos) instanceof ILockable) continue;
                    blocksToRemove.add(blockPos);
                }
                for (BlockPos posToRemove : blocksToRemove) {
                    this.delink(posToRemove, false);
                    this.sync();
                }
                if (this.emitsPings && !this.isRecording) {
                    level.m_5594_(null, this.f_58858_, SCSounds.PING.event, SoundSource.BLOCKS, 0.3f, 1.0f);
                }
                this.pingCooldown = 100;
            }
        } else if (this.isActive() || this.isRecording()) {
            this.oRadarRotationDegrees = this.radarRotationDegrees;
            this.radarRotationDegrees = (float)((double)this.radarRotationDegrees + 0.15);
            if (this.radarRotationDegrees >= 360.0f) {
                this.radarRotationDegrees = 0.0f;
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        BlockEntityTracker.SONIC_SECURITY_SYSTEM.stopTracking(this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        if (module == ModuleType.REDSTONE) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
        }
        super.onModuleRemoved(stack, module, toggled);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.linkedBlocks.size() > 0 && !tag.m_128441_("LinkedBlocks")) {
            tag.m_128365_("LinkedBlocks", (Tag)new ListTag());
        }
        for (BlockPos blockToSave : this.linkedBlocks) {
            CompoundTag nbt = NbtUtils.m_129224_((BlockPos)blockToSave);
            tag.m_128437_("LinkedBlocks", 10).add((Object)nbt);
            if (this.linkedBlocks.contains(blockToSave)) continue;
            this.linkedBlocks.add(blockToSave);
        }
        this.saveNotes(tag);
        tag.m_128379_("emitsPings", this.emitsPings);
        tag.m_128379_("isActive", this.isActive);
        tag.m_128379_("isRecording", this.isRecording);
        tag.m_128379_("isListening", this.isListening);
        tag.m_128405_("listenPos", this.listenPos);
        tag.m_128379_("correctTuneWasPlayed", this.correctTuneWasPlayed);
        tag.m_128405_("powerCooldown", this.powerCooldown);
        tag.m_128379_("shutDown", this.shutDown);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("LinkedBlocks")) {
            ListTag list = tag.m_128437_("LinkedBlocks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag linkedBlock = list.m_128728_(i);
                BlockPos linkedBlockPos = NbtUtils.m_129239_((CompoundTag)linkedBlock);
                this.linkedBlocks.add(linkedBlockPos);
            }
        }
        this.recordedNotes.clear();
        SonicSecuritySystemBlockEntity.loadNotes(tag, this.recordedNotes);
        if (tag.m_128441_("emitsPings")) {
            this.emitsPings = tag.m_128471_("emitsPings");
        }
        if (tag.m_128441_("isActive")) {
            this.isActive = tag.m_128471_("isActive");
        }
        this.isRecording = tag.m_128471_("isRecording");
        this.isListening = tag.m_128471_("isListening");
        this.listenPos = tag.m_128451_("listenPos");
        this.correctTuneWasPlayed = tag.m_128471_("correctTuneWasPlayed");
        this.powerCooldown = tag.m_128451_("powerCooldown");
        this.shutDown = tag.m_128471_("shutDown");
    }

    public void saveNotes(CompoundTag tag) {
        ListTag notes = new ListTag();
        for (NoteWrapper note : this.recordedNotes) {
            CompoundTag noteNbt = new CompoundTag();
            noteNbt.m_128405_("noteID", note.noteID);
            noteNbt.m_128359_("instrument", note.instrumentName);
            notes.add((Object)noteNbt);
        }
        tag.m_128365_("Notes", (Tag)notes);
    }

    public static <T extends Collection<NoteWrapper>> void loadNotes(CompoundTag tag, T recordedNotes) {
        if (tag.m_128441_("Notes")) {
            ListTag list = tag.m_128437_("Notes", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag note = list.m_128728_(i);
                recordedNotes.add((NoteWrapper)new NoteWrapper(note.m_128451_("noteID"), note.m_128461_("instrument")));
            }
        }
    }

    public boolean transferPositionsFromItem(CompoundTag itemTag) {
        Set<BlockPos> positions = SonicSecuritySystemItem.stackTagToBlockPosSet(itemTag);
        positions.removeIf(this::isLinkedToBlock);
        this.linkedBlocks.addAll(positions);
        if (!this.linkedBlocks.isEmpty()) {
            this.sync();
        }
        return true;
    }

    public boolean isLinkedToBlock() {
        return !this.linkedBlocks.isEmpty();
    }

    public boolean isLinkedToBlock(BlockPos linkedBlockPos) {
        if (this.linkedBlocks.isEmpty()) {
            return false;
        }
        return this.linkedBlocks.contains(linkedBlockPos);
    }

    public void delink(BlockPos linkedBlockPos, boolean shouldSync) {
        if (this.linkedBlocks.isEmpty()) {
            return;
        }
        this.linkedBlocks.remove(linkedBlockPos);
        if (shouldSync) {
            this.sync();
        }
    }

    public void delinkAll() {
        this.linkedBlocks.clear();
        this.sync();
    }

    public int getNumberOfLinkedBlocks() {
        return this.linkedBlocks.size();
    }

    public Set<BlockPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public boolean pings() {
        return this.emitsPings;
    }

    public void setPings(boolean pings) {
        this.emitsPings = pings;
    }

    public boolean isActive() {
        return this.isActive && !this.isShutDown();
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean recording) {
        this.isRecording = recording;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void startListening() {
        this.isListening = true;
    }

    public void stopListening() {
        this.resetListeningTimer();
        this.listenPos = 0;
        this.isListening = false;
        this.f_58857_.m_6289_(this.f_58858_, (Block)SCContent.SONIC_SECURITY_SYSTEM.get());
        if (!this.f_58857_.f_46443_) {
            this.sync();
        }
    }

    public void resetListeningTimer() {
        this.listeningTimer = 60;
    }

    public void recordNote(int noteID, String instrumentName) {
        this.recordedNotes.add(new NoteWrapper(noteID, instrumentName));
        if (!this.f_58857_.f_46443_) {
            this.sync();
        }
    }

    public boolean listenToNote(int noteID, String instrumentName) {
        if (this.getNumberOfNotes() == 0 || this.listenPos >= this.getNumberOfNotes()) {
            return false;
        }
        if (!this.isListening) {
            this.isListening = true;
            this.sync();
        }
        if (this.recordedNotes.get(this.listenPos++).isSameNote(noteID, instrumentName)) {
            this.resetListeningTimer();
            return this.listenPos >= this.recordedNotes.size();
        }
        return false;
    }

    public ArrayList<NoteWrapper> getRecordedNotes() {
        return this.recordedNotes;
    }

    public int getNumberOfNotes() {
        return this.recordedNotes.size();
    }

    public void clearNotes() {
        this.recordedNotes.clear();
    }

    private void sync() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength};
    }

    public record NoteWrapper(int noteID, String instrumentName) {
        public boolean isSameNote(int note, String instrument) {
            return this.noteID == note && this.instrumentName.equals(instrument);
        }
    }
}

