/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedPressurePlateBlock
extends PressurePlateBlock
implements IReinforcedBlock,
EntityBlock {
    private final Block vanillaBlock;

    public ReinforcedPressurePlateBlock(PressurePlateBlock.Sensitivity sensitivity, BlockBehaviour.Properties properties, Block vanillaBlock) {
        super(sensitivity, properties);
        this.vanillaBlock = vanillaBlock;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        int redstoneStrength = this.m_6016_(state);
        if (!level.f_46443_ && redstoneStrength == 0 && entity instanceof Player) {
            AllowlistOnlyBlockEntity be;
            Player player = (Player)entity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AllowlistOnlyBlockEntity && this.isAllowedToPress(level, pos, be = (AllowlistOnlyBlockEntity)blockEntity, player)) {
                this.m_152143_((Entity)player, level, pos, state, redstoneStrength);
            }
        }
    }

    protected int m_6693_(Level level, BlockPos pos) {
        Object object;
        AABB aabb = f_49287_.m_82338_(pos);
        List list = level.m_45933_(null, aabb);
        if (!list.isEmpty() && (object = level.m_7702_(pos)) instanceof AllowlistOnlyBlockEntity) {
            AllowlistOnlyBlockEntity be = (AllowlistOnlyBlockEntity)object;
            for (Entity entity : list) {
                Player player;
                if (!(entity instanceof Player) || !this.isAllowedToPress(level, pos, be, player = (Player)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!isMoving && this.m_6016_(state) > 0) {
                level.m_46672_(pos, (Block)this);
                level.m_46672_(pos.m_7495_(), (Block)this);
            }
            if (!newState.m_155947_()) {
                level.m_46747_(pos);
            }
        }
    }

    public boolean isAllowedToPress(Level level, BlockPos pos, AllowlistOnlyBlockEntity be, Player entity) {
        return be.isOwnedBy(entity) || be.isAllowed((Entity)entity);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, (Player)placer));
        }
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.m_49966_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AllowlistOnlyBlockEntity(pos, state);
    }

    public static class DoorActivator
    implements IDoorActivator {
        private final List<Block> blocks = Arrays.asList((Block)SCContent.REINFORCED_STONE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_SPRUCE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_BIRCH_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_JUNGLE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_ACACIA_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_DARK_OAK_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_CRIMSON_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_WARPED_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_POLISHED_BLACKSTONE_PRESSURE_PLATE.get());

        @Override
        public boolean isPowering(Level level, BlockPos pos, BlockState state, BlockEntity be, Direction direction, int distance) {
            return (Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_) != false && (distance < 2 || direction == Direction.UP);
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

