/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BriefcaseItem
extends Item
implements DyeableLeatherItem {
    public BriefcaseItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onItemUse(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43722_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43724_());
    }

    public InteractionResult onItemUse(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ, InteractionHand hand) {
        this.handle(stack, level, player, hand);
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.handle(stack, level, player, hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private void handle(ItemStack stack, Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            if (!stack.m_41784_().m_128441_("passcode")) {
                ClientHandler.displayBriefcaseSetupScreen(stack.m_41786_());
            } else {
                ClientHandler.displayBriefcasePasswordScreen(stack.m_41786_());
            }
        }
    }

    public void m_7373_(ItemStack briefcase, Level level, List<Component> tooltip, TooltipFlag flag) {
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        if (!ownerName.isEmpty()) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:briefcase.owner", ownerName).m_6270_(Utils.GRAY_STYLE));
        }
    }

    public static boolean isOwnedBy(ItemStack briefcase, Player player) {
        if (!briefcase.m_41782_()) {
            return true;
        }
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
        return ownerName.isEmpty() || ownerUUID.equals(player.m_142081_().toString()) || ownerUUID.equals("ownerUUID") && ownerName.equals(player.m_7755_().getString());
    }

    public static String getOwnerName(ItemStack briefcase) {
        return briefcase.m_41782_() ? briefcase.m_41783_().m_128461_("owner") : "";
    }

    public static String getOwnerUUID(ItemStack briefcase) {
        return briefcase.m_41782_() ? briefcase.m_41783_().m_128461_("ownerUUID") : "";
    }
}

