/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TaserItem
extends Item {
    public boolean powered;

    public TaserItem(Item.Properties properties, boolean isPowered) {
        super(properties);
        this.powered = isPowered;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!(group != SecurityCraft.technicalTab && group != CreativeModeTab.f_40754_ || this.powered)) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41768_()) return InteractionResultHolder.m_19098_((Object)stack);
        if (player.m_6047_() && (player.m_7500_() || !this.powered)) {
            ItemStack redstoneStack;
            ItemStack oneRedstone = new ItemStack((ItemLike)Items.f_42451_, 1);
            if (player.m_7500_()) {
                if (player.m_21120_(hand).m_41720_() == SCContent.TASER.get()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)SCContent.TASER_POWERED.get(), 1));
                    return InteractionResultHolder.m_19090_((Object)stack);
                } else {
                    player.m_21008_(hand, new ItemStack((ItemLike)SCContent.TASER.get(), 1));
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (!player.m_150109_().m_36063_(oneRedstone)) return InteractionResultHolder.m_19098_((Object)stack);
            int redstoneSlot = player.m_150109_().m_36043_(oneRedstone);
            if (redstoneSlot == -1) {
                if (player.m_21206_().m_41720_() != Items.f_42451_) return InteractionResultHolder.m_19098_((Object)stack);
                redstoneStack = player.m_21206_();
            } else {
                redstoneStack = player.m_150109_().m_8020_(redstoneSlot);
            }
            redstoneStack.m_41764_(redstoneStack.m_41613_() - 1);
            if (redstoneSlot == -1) {
                player.m_150109_().f_35976_.set(0, (Object)redstoneStack);
            } else {
                player.m_150109_().m_6836_(redstoneSlot, redstoneStack);
            }
            player.m_21008_(hand, new ItemStack((ItemLike)SCContent.TASER_POWERED.get(), 1));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        int range = 11;
        Vec3 startVec = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f).m_82490_((double)range);
        Vec3 endVec = startVec.m_82549_(lookVec);
        AABB boundingBox = player.m_142469_().m_82369_(lookVec).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)startVec, (Vec3)endVec, (AABB)boundingBox, s -> s instanceof LivingEntity, (double)(range * range));
        level.m_5594_(player, player.m_142538_(), SCSounds.TASERFIRED.event, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157778_, player.m_142538_());
        if (hitResult != null) {
            LivingEntity entity = (LivingEntity)hitResult.m_82443_();
            double damage = this.powered ? (Double)ConfigHandler.SERVER.poweredTaserDamage.get() : (Double)ConfigHandler.SERVER.taserDamage.get();
            if (!entity.m_21254_() && (damage == 0.0 || entity.m_6469_(CustomDamageSources.TASER, (float)damage))) {
                List<Supplier<MobEffectInstance>> effects = this.powered ? ConfigHandler.SERVER.poweredTaserEffects : ConfigHandler.SERVER.taserEffects;
                effects.forEach(effect -> entity.m_7292_((MobEffectInstance)effect.get()));
            }
        }
        if (player.m_7500_()) return InteractionResultHolder.m_19096_((Object)stack);
        if (this.powered) {
            ItemStack taser = new ItemStack((ItemLike)SCContent.TASER.get(), 1);
            taser.m_41622_(150, (LivingEntity)player, p -> p.m_21190_(hand));
            player.m_21008_(hand, taser);
            return InteractionResultHolder.m_19096_((Object)stack);
        } else {
            stack.m_41622_(150, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotIndex, boolean isSelected) {
        if (!level.f_46443_ && stack.m_41773_() >= 1) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

