/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public class UniversalKeyChangerItem
extends Item {
    public UniversalKeyChangerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return this.onItemUseFirst(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43722_(), ctx.m_43724_());
    }

    public InteractionResult onItemUseFirst(Player player, Level level, BlockPos pos, Direction side, ItemStack stack, InteractionHand hand) {
        InteractionResult briefcaseResult = this.handleBriefcase(player, hand).m_19089_();
        if (briefcaseResult != InteractionResult.PASS) {
            return briefcaseResult;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IPasswordProtected) {
            DisguisableBlock db;
            if (((IOwnable)be).isOwnedBy(player)) {
                if (!level.f_46443_) {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.UNIVERSAL_KEY_CHANGER, pos));
                }
                return InteractionResult.SUCCESS;
            }
            Block block = be.m_58900_().m_60734_();
            if (!(block instanceof DisguisableBlock) || ((BlockItem)(db = (DisguisableBlock)block).getDisguisedStack((BlockGetter)level, pos).m_41720_()).m_40614_() instanceof DisguisableBlock) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)level.m_7702_(pos)).getOwner().getName())), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return this.handleBriefcase(player, hand);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Player player, InteractionHand hand) {
        ItemStack keyChanger = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.m_21206_();
            if (BriefcaseItem.isOwnedBy(briefcase, player)) {
                if (briefcase.m_41782_() && briefcase.m_41783_().m_128441_("passcode")) {
                    briefcase.m_41783_().m_128473_("passcode");
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.passcodeReset", new Object[0]), ChatFormatting.GREEN);
                    return InteractionResultHolder.m_19090_((Object)keyChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.noPasscode", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.notOwned", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResultHolder.m_19096_((Object)keyChanger);
        }
        return InteractionResultHolder.m_19098_((Object)keyChanger);
    }
}

