/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SecurityCameraRenderer
implements BlockEntityRenderer<SecurityCameraBlockEntity> {
    private static final Quaternion POSITIVE_Y_180 = Vector3f.f_122225_.m_122240_(180.0f);
    private static final Quaternion POSITIVE_Y_90 = Vector3f.f_122225_.m_122240_(90.0f);
    private static final Quaternion NEGATIVE_Y_90 = Vector3f.f_122224_.m_122240_(90.0f);
    private static final Quaternion POSITIVE_X_180 = Vector3f.f_122223_.m_122240_(180.0f);
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/block/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = new ResourceLocation("securitycraft:textures/block/security_camera_viewing.png");
    private final SecurityCameraModel model;

    public SecurityCameraRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SecurityCameraModel(ctx.m_173582_(ClientHandler.SECURITY_CAMERA_LOCATION));
    }

    public void render(SecurityCameraBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state;
        if (be.down || PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91075_.m_142538_().equals((Object)be.m_58899_())) {
            return;
        }
        pose.m_85837_(0.5, 1.5, 0.5);
        if (be.m_58898_() && (state = be.m_58904_().m_8055_(be.m_58899_())).m_60734_() == SCContent.SECURITY_CAMERA.get()) {
            Direction side = (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING);
            if (side == Direction.NORTH) {
                pose.m_85845_(POSITIVE_Y_180);
            } else if (side == Direction.EAST) {
                pose.m_85845_(POSITIVE_Y_90);
            } else if (side == Direction.WEST) {
                pose.m_85845_(NEGATIVE_Y_90);
            }
        }
        pose.m_85845_(POSITIVE_X_180);
        if (!be.isDisabled()) {
            this.model.cameraRotationPoint.f_104204_ = (float)Mth.m_14139_((double)partialTicks, (double)be.oCameraRotation, (double)be.cameraRotation);
        }
        this.model.cameraRotationPoint.f_104203_ = be.isShutDown() ? 0.9f : 0.2617994f;
        this.model.m_7695_(pose, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)((Boolean)be.m_58900_().m_61143_((Property)SecurityCameraBlock.BEING_VIEWED) != false ? BEING_VIEWED_TEXTURE : TEXTURE))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

