/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class EditModuleScreen
extends Screen {
    private static CompoundTag savedModule;
    private static final ResourceLocation TEXTURE;
    private static final ResourceLocation BEACON_GUI;
    private final TranslatableComponent editModule = Utils.localize("gui.securitycraft:editModule", new Object[0]);
    private final ItemStack module;
    private final List<PlayerTeam> availableTeams;
    private final Map<PlayerTeam, Boolean> teamsListedStatus = new HashMap<PlayerTeam, Boolean>();
    private EditBox inputField;
    private Button addPlayerButton;
    private Button editTeamsButton;
    private Button removePlayerButton;
    private Button copyButton;
    private Button pasteButton;
    private Button clearButton;
    private CallbackCheckbox affectEveryPlayerCheckbox;
    private int xSize = 247;
    private int ySize = 211;
    private PlayerList playerList;
    private TeamList teamList;
    private int guiLeft;

    public EditModuleScreen(ItemStack item) {
        super((Component)new TranslatableComponent(item.m_41778_()));
        this.availableTeams = new ArrayList<PlayerTeam>(Minecraft.m_91087_().f_91074_.m_36329_().m_83491_());
        this.module = item;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        int guiTop = (this.f_96544_ - this.ySize) / 2;
        int controlsStartX = (int)((float)this.guiLeft + (float)this.xSize * 0.75f) - 57;
        int controlsWidth = 107;
        TranslatableComponent checkboxText = Utils.localize("gui.securitycraft:editModule.affectEveryone", new Object[0]);
        int length = this.f_96547_.m_92852_((FormattedText)checkboxText) + 24;
        this.f_96541_.f_91068_.m_90926_(true);
        this.inputField = new EditBox(this.f_96547_, controlsStartX, this.f_96544_ / 2 - 88, 107, 15, TextComponent.f_131282_);
        this.m_142416_((GuiEventListener)this.inputField);
        this.addPlayerButton = new ExtendedButton(controlsStartX, this.f_96544_ / 2 - 68, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.add_player", new Object[0]), this::addPlayerButtonClicked);
        this.m_142416_((GuiEventListener)this.addPlayerButton);
        this.removePlayerButton = new ExtendedButton(controlsStartX, this.f_96544_ / 2 - 43, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.remove_player", new Object[0]), this::removePlayerButtonClicked);
        this.m_142416_((GuiEventListener)this.removePlayerButton);
        this.editTeamsButton = new NonScrollableToggleComponentButton(controlsStartX, this.f_96544_ / 2 - 18, controlsWidth, 20, i -> Utils.localize("gui.securitycraft:editModule.edit_teams", new Object[0]), 0, 2, this::editTeamsButtonClicked);
        this.m_142416_((GuiEventListener)this.editTeamsButton);
        this.copyButton = new ExtendedButton(controlsStartX, this.f_96544_ / 2 + 7, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.copy", new Object[0]), this::copyButtonClicked);
        this.m_142416_((GuiEventListener)this.copyButton);
        this.pasteButton = new ExtendedButton(controlsStartX, this.f_96544_ / 2 + 32, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.paste", new Object[0]), this::pasteButtonClicked);
        this.m_142416_((GuiEventListener)this.pasteButton);
        this.clearButton = new ExtendedButton(controlsStartX, this.f_96544_ / 2 + 57, controlsWidth, 20, (Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0]), this::clearButtonClicked);
        this.m_142416_((GuiEventListener)this.clearButton);
        this.playerList = new PlayerList(this.f_96541_, 110, 165, this.f_96544_ / 2 - 88, this.guiLeft + 10);
        this.m_142416_((GuiEventListener)this.playerList);
        this.teamList = new TeamList(this.f_96541_, this.editTeamsButton.m_5711_(), 75, this.editTeamsButton.f_93621_ + this.editTeamsButton.m_93694_(), this.editTeamsButton.f_93620_);
        this.m_142416_((GuiEventListener)this.teamList);
        this.affectEveryPlayerCheckbox = new CallbackCheckbox(this.guiLeft + this.xSize / 2 - length / 2, guiTop + this.ySize - 25, 20, 20, (Component)checkboxText, this.module.m_41782_() && this.module.m_41783_().m_128471_("affectEveryone"), newState -> this.module.m_41784_().m_128379_("affectEveryone", newState.booleanValue()), 0x404040);
        this.m_142416_((GuiEventListener)this.affectEveryPlayerCheckbox);
        this.teamList.active = false;
        this.editTeamsButton.f_93623_ = !this.availableTeams.isEmpty();
        this.refreshFromNbt();
        this.updateButtonStates();
        this.inputField.m_94199_(16);
        this.inputField.m_94153_(s -> !s.contains(" "));
        this.inputField.m_94151_(s -> {
            if (s.isEmpty()) {
                this.addPlayerButton.f_93623_ = false;
            } else {
                if (this.module.m_41782_()) {
                    for (int i = 1; i <= 50; ++i) {
                        if (!s.equals(this.module.m_41783_().m_128461_("Player" + i))) continue;
                        this.addPlayerButton.f_93623_ = false;
                        this.removePlayerButton.f_93623_ = true;
                        this.playerList.setSelectedIndex(i - 1);
                        return;
                    }
                }
                this.addPlayerButton.f_93623_ = true;
            }
            this.removePlayerButton.f_93623_ = false;
            this.playerList.setSelectedIndex(-1);
        });
        this.m_94718_((GuiEventListener)this.inputField);
    }

    public void m_7379_() {
        super.m_7379_();
        SecurityCraft.channel.sendToServer((Object)new SetListModuleData(this.module.m_41784_()));
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, startX, startY, 0, 0, this.xSize, this.ySize);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92857_((FormattedText)this.editModule, startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.editModule) / 2, startY + 6, this.f_96543_, 0x404040);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.m_6348_(mouseX, mouseY, button);
        }
        if (this.teamList != null) {
            this.teamList.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.playerList != null) {
            this.playerList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.teamList != null) {
            this.teamList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.inputField.m_93696_() && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private void addPlayerButtonClicked(Button button) {
        if (this.inputField.m_94155_().isEmpty()) {
            return;
        }
        if (this.module.m_41783_() == null) {
            this.module.m_41751_(new CompoundTag());
        }
        for (int i = 1; i <= 50; ++i) {
            if (!this.module.m_41783_().m_128441_("Player" + i) || !this.module.m_41783_().m_128461_("Player" + i).equals(this.inputField.m_94155_())) continue;
            if (i == 9) {
                this.addPlayerButton.f_93623_ = false;
            }
            return;
        }
        this.module.m_41783_().m_128359_("Player" + this.getNextFreeSlot(this.module.m_41783_()), this.inputField.m_94155_());
        if (this.module.m_41783_() != null && this.module.m_41783_().m_128441_("Player50")) {
            this.addPlayerButton.f_93623_ = false;
        }
        this.inputField.m_94144_("");
        this.updateButtonStates();
    }

    private void editTeamsButtonClicked(Button button) {
        boolean buttonState;
        this.pasteButton.f_93624_ = this.clearButton.f_93624_ = (buttonState = ((ToggleComponentButton)button).getCurrentIndex() == 0);
        this.copyButton.f_93624_ = this.clearButton.f_93624_;
        this.teamList.active = !buttonState;
    }

    private void removePlayerButtonClicked(Button button) {
        if (this.inputField.m_94155_().isEmpty()) {
            return;
        }
        if (this.module.m_41783_() == null) {
            this.module.m_41751_(new CompoundTag());
        }
        for (int i = 1; i <= 50; ++i) {
            if (!this.module.m_41783_().m_128441_("Player" + i) || !this.module.m_41783_().m_128461_("Player" + i).equals(this.inputField.m_94155_())) continue;
            this.module.m_41783_().m_128473_("Player" + i);
            this.defragmentTag(this.module.m_41783_());
        }
        this.inputField.m_94144_("");
        this.updateButtonStates();
    }

    private void copyButtonClicked(Button button) {
        savedModule = this.module.m_41783_().m_6426_();
        this.copyButton.f_93623_ = false;
        this.updateButtonStates();
    }

    private void pasteButtonClicked(Button button) {
        this.module.m_41751_(savedModule.m_6426_());
        this.updateButtonStates();
        this.refreshFromNbt();
    }

    private void clearButtonClicked(Button button) {
        this.module.m_41751_(new CompoundTag());
        this.inputField.m_94144_("");
        this.updateButtonStates(true);
        this.refreshFromNbt();
    }

    private void updateButtonStates() {
        this.updateButtonStates(false);
    }

    private void updateButtonStates(boolean cleared) {
        boolean tagIsConsideredEmpty;
        CompoundTag tag = this.module.m_41784_();
        boolean bl = tagIsConsideredEmpty = tag.m_128456_() || tag.m_128440_() == 1 && tag.m_128441_("affectEveryone");
        if (!cleared && tagIsConsideredEmpty) {
            this.addPlayerButton.f_93623_ = false;
            this.removePlayerButton.f_93623_ = false;
        } else {
            this.addPlayerButton.f_93623_ = !tag.m_128441_("Player50") && !this.inputField.m_94155_().isEmpty();
            this.removePlayerButton.f_93623_ = !this.inputField.m_94155_().isEmpty();
        }
        this.copyButton.f_93623_ = !tagIsConsideredEmpty && !tag.equals((Object)savedModule);
        this.pasteButton.f_93623_ = savedModule != null && !savedModule.m_128456_() && !tag.equals((Object)savedModule);
        this.clearButton.f_93623_ = !tagIsConsideredEmpty;
    }

    private void refreshFromNbt() {
        if (!this.module.m_41782_()) {
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((PlayerTeam)team, false));
            this.affectEveryPlayerCheckbox.setSelected(false);
        } else {
            CompoundTag tag = this.module.m_41783_();
            List<String> teamNames = tag.m_128437_("ListedTeams", 8).stream().filter(e -> e instanceof StringTag).map(e -> ((StringTag)e).m_7916_()).toList();
            this.availableTeams.forEach(team -> this.teamsListedStatus.put((PlayerTeam)team, teamNames.contains(team.m_5758_())));
            this.affectEveryPlayerCheckbox.setSelected(tag.m_128471_("affectEveryone"));
        }
    }

    private int getNextFreeSlot(CompoundTag tag) {
        for (int i = 1; i <= 50; ++i) {
            if (tag.m_128441_("Player" + i) && !tag.m_128461_("Player" + i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    private void toggleTeam(PlayerTeam teamToAdd) {
        ListTag listedTeams = new ListTag();
        this.teamsListedStatus.put(teamToAdd, this.teamsListedStatus.get(teamToAdd) == false);
        this.teamsListedStatus.forEach((team, listed) -> {
            if (listed.booleanValue()) {
                listedTeams.add((Object)StringTag.m_129297_((String)team.m_5758_()));
            }
        });
        this.module.m_41784_().m_128365_("ListedTeams", (Tag)listedTeams);
        this.updateButtonStates();
    }

    private void defragmentTag(CompoundTag tag) {
        ArrayDeque<Integer> freeIndices = new ArrayDeque<Integer>();
        for (int i = 1; i <= 50; ++i) {
            if (!tag.m_128441_("Player" + i) || tag.m_128461_("Player" + i).isEmpty()) {
                freeIndices.add(i);
                continue;
            }
            if (freeIndices.isEmpty()) continue;
            String player = tag.m_128461_("Player" + i);
            int nextFreeIndex = (Integer)freeIndices.poll();
            tag.m_128359_("Player" + nextFreeIndex, player);
            tag.m_128473_("Player" + i);
            freeIndices.add(i);
        }
    }

    private void renderBox(BufferBuilder bufferBuilder, int min, int max, int slotTop, int slotBuffer, int borderColor) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
        bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
        bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
        bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(borderColor, borderColor, borderColor, 255).m_5752_();
        bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    static {
        TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/edit_module.png");
        BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    }

    class NonScrollableToggleComponentButton
    extends ToggleComponentButton {
        public NonScrollableToggleComponentButton(int xPos, int yPos, int width, int height, IntFunction<Component> onValueChange, int initialValue, int toggleCount, Button.OnPress onPress) {
            super(xPos, yPos, width, height, onValueChange, initialValue, toggleCount, onPress);
        }

        @Override
        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            return false;
        }
    }

    class PlayerList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private final int listLength = 50;
        private int selectedIndex;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.listLength = 50;
            this.selectedIndex = -1;
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.f_96547_);
            int height = 50 * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY) && mouseX < (double)(this.left + this.width - 6)) {
                int clickedIndex = (int)(mouseY - (double)this.top + (double)this.scrollDistance - (double)this.border) / 12;
                if (EditModuleScreen.this.module.m_41782_() && EditModuleScreen.this.module.m_41783_().m_128441_("Player" + (clickedIndex + 1))) {
                    this.selectedIndex = clickedIndex;
                    EditModuleScreen.this.inputField.m_94144_(EditModuleScreen.this.module.m_41783_().m_128461_("Player" + (clickedIndex + 1)));
                }
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tessellator, int mouseX, int mouseY) {
            if (EditModuleScreen.this.module.m_41782_()) {
                CompoundTag tag = EditModuleScreen.this.module.m_41783_();
                int baseY = this.top + this.border - (int)this.scrollDistance;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                int slotIndex = mouseListY / 12;
                if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 50 && mouseY >= this.top && mouseY <= this.bottom && tag.m_128441_("Player" + (slotIndex + 1)) && !tag.m_128461_("Player" + (slotIndex + 1)).isEmpty()) {
                    EditModuleScreen.this.renderBox(tessellator.m_85915_(), this.left, entryRight - 6, baseY + slotIndex * 12, 8, 128);
                }
                if (this.selectedIndex >= 0) {
                    EditModuleScreen.this.renderBox(tessellator.m_85915_(), this.left, entryRight - 6, baseY + this.selectedIndex * 12, 8, 255);
                }
                for (int i = 0; i < 50; ++i) {
                    String name;
                    if (!tag.m_128441_("Player" + (i + 1)) || (name = tag.m_128461_("Player" + (i + 1))).isEmpty()) continue;
                    EditModuleScreen.this.f_96547_.m_92883_(pose, name, (float)(this.left - 2 + this.width / 2 - EditModuleScreen.this.f_96547_.m_92895_(name) / 2), (float)(relativeY + 12 * i), 0xC6C6C6);
                }
            }
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    class TeamList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private final int listLength;
        private int selectedIndex;
        public boolean active;

        public TeamList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.slotHeight = 12;
            this.selectedIndex = -1;
            this.active = true;
            this.listLength = EditModuleScreen.this.availableTeams.size();
        }

        protected int getContentHeight() {
            Objects.requireNonNull(EditModuleScreen.this.f_96547_);
            int height = this.listLength * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex;
            if (this.active && (slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12) >= 0 && mouseY >= 0.0 && slotIndex < this.listLength) {
                EditModuleScreen.this.toggleTeam(EditModuleScreen.this.availableTeams.get(slotIndex));
                EditModuleScreen.this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return false;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            if (this.active) {
                super.m_6305_(pose, mouseX, mouseY, partialTick);
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
                int slotIndex = mouseListY / 12;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                    Component name = EditModuleScreen.this.availableTeams.get(slotIndex).m_83364_();
                    int length = EditModuleScreen.this.f_96547_.m_92852_((FormattedText)name);
                    int baseY = this.top + this.border - (int)this.scrollDistance;
                    if (length >= this.width - 6) {
                        EditModuleScreen.this.m_96602_(pose, name, this.left + 3, baseY + (12 * slotIndex + 12));
                    }
                }
            }
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tessellator, int mouseX, int mouseY) {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (slotIndex != this.selectedIndex && mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.listLength && mouseY >= this.top && mouseY <= this.bottom) {
                EditModuleScreen.this.renderBox(tessellator.m_85915_(), this.left, entryRight - 6, baseY + slotIndex * 12, 8, 128);
            }
            for (int i = 0; i < this.listLength; ++i) {
                int yStart = relativeY + 12 * i;
                PlayerTeam team = EditModuleScreen.this.availableTeams.get(i);
                EditModuleScreen.this.f_96547_.m_92889_(pose, team.m_83364_(), (float)(this.left + 15), (float)yStart, 0xC6C6C6);
                RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
                TeamList.m_93160_((PoseStack)pose, (int)this.left, (int)(yStart - 3), (int)14, (int)14, (float)(EditModuleScreen.this.teamsListedStatus.get(team) != false ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)256, (int)256);
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

