/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Arrays;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ClientUtils {
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/item/module_background.png"), new ResourceLocation("securitycraft", "textures/item/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/item/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/item/harming_module.png"), new ResourceLocation("securitycraft", "textures/item/smart_module.png"), new ResourceLocation("securitycraft", "textures/item/storage_module.png"), new ResourceLocation("securitycraft", "textures/item/disguise_module.png"), new ResourceLocation("securitycraft", "textures/item/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/item/redstone.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/item/sugar.png");

    public static String getFormattedMinecraftTime() {
        Long time = Minecraft.m_91087_().f_91073_.m_46468_();
        int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
    }

    public static void renderModuleInfo(PoseStack pose, ModuleType module, Component moduleTooltip, Component noModuleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        Matrix4f m4f = pose.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157179_((int)0, (ResourceLocation)MODULE_TEXTURES[module.ordinal()]);
        ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == ModuleType.REDSTONE) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)REDSTONE_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == ModuleType.SPEED) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)SUGAR_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        RenderSystem.m_69461_();
        if (mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom) {
            Component text;
            Component component = text = isModuleInstalled ? moduleTooltip : noModuleTooltip;
            if (text != null && mc.f_91080_ != null) {
                mc.f_91080_.m_96597_(pose, Arrays.asList(text), mouseX, mouseY);
            }
        }
    }

    private static void drawTexture(BufferBuilder bufferBuilder, Matrix4f m4f, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_85982_(m4f, (float)moduleLeft, (float)moduleBottom, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(m4f, (float)moduleRight, (float)moduleBottom, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(m4f, (float)moduleRight, (float)moduleTop, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(m4f, (float)moduleLeft, (float)moduleTop, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderBoxInLevel(MultiBufferSource buffer, Matrix4f positionMatrix, int minX, int maxX, int minZ, int maxZ, int height, int rgbColor) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110504_());
        int r = rgbColor >> 16 & 0xFF;
        int g = rgbColor >> 8 & 0xFF;
        int b = rgbColor & 0xFF;
        builder.m_85982_(positionMatrix, (float)minX, 0.0f, (float)minZ).m_6122_(r, g, b, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, 0.0f, (float)minZ).m_6122_(r, g, b, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, 0.0f, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, 0.0f, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, 0.0f, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, 0.0f, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, 0.0f, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, 0.0f, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, (float)height, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, (float)height, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, (float)height, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, (float)height, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, (float)height, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, (float)height, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, (float)height, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, (float)height, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, 0.0f, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, (float)height, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, 0.0f, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)minX, (float)height, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, 0.0f, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, (float)height, (float)maxZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, 0.0f, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_85982_(positionMatrix, (float)maxX, (float)height, (float)minZ).m_6122_(r, g, b, 255).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
    }

    public static void fillHorizontalGradient(PoseStack pose, int zLevel, int left, int top, int right, int bottom, int fromColor, int toColor) {
        float fromAlpha = (float)(fromColor >> 24 & 0xFF) / 255.0f;
        float fromRed = (float)(fromColor >> 16 & 0xFF) / 255.0f;
        float fromGreen = (float)(fromColor >> 8 & 0xFF) / 255.0f;
        float fromBlue = (float)(fromColor & 0xFF) / 255.0f;
        float toAlpha = (float)(toColor >> 24 & 0xFF) / 255.0f;
        float toRed = (float)(toColor >> 16 & 0xFF) / 255.0f;
        float toGreen = (float)(toColor >> 8 & 0xFF) / 255.0f;
        float toBlue = (float)(toColor & 0xFF) / 255.0f;
        Matrix4f mat = pose.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(mat, (float)right, (float)top, (float)zLevel).m_85950_(toRed, toGreen, toBlue, toAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)top, (float)zLevel).m_85950_(fromRed, fromGreen, fromBlue, fromAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(fromRed, fromGreen, fromBlue, fromAlpha).m_5752_();
        buffer.m_85982_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(toRed, toGreen, toBlue, toAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        float[] hsb = new float[3];
        int cmax = r > g ? r : g;
        int n = cmin = r < g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsb[0] = hue;
        hsb[1] = saturation;
        hsb[2] = brightness;
        return hsb;
    }
}

