/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean useNBT;

    public ComparableItemStack(ItemStack stack) {
        this(stack, false);
    }

    public ComparableItemStack(ItemStack stack, boolean copy) {
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        if (copy) {
            this.copy();
        }
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy) {
        return ComparableItemStack.create(stack, copy, stack.m_41782_() && !stack.m_41784_().m_128456_());
    }

    public static ComparableItemStack create(ItemStack stack, boolean copy, boolean useNbt) {
        ComparableItemStack comp = new ComparableItemStack(stack, copy);
        comp.setUseNBT(useNbt);
        return comp;
    }

    public void copy() {
        this.stack = this.stack.m_41777_();
    }

    public ComparableItemStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; checkNBT: " + this.useNBT;
    }

    public int hashCode() {
        int hash = this.stack.m_41720_().hashCode();
        if (this.useNBT && this.stack.m_41782_()) {
            hash += this.stack.m_41784_().hashCode() * 31;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!ItemStack.m_41746_((ItemStack)this.stack, (ItemStack)otherStack)) {
            return false;
        }
        if (this.useNBT) {
            return ItemStack.m_41658_((ItemStack)this.stack, (ItemStack)otherStack);
        }
        return true;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        nbt.m_128379_("useNBT", this.useNBT);
        return nbt;
    }

    public static ComparableItemStack readFromNBT(CompoundTag nbt) {
        ComparableItemStack comp = new ComparableItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack")), false);
        comp.useNBT = nbt.m_128471_("useNBT");
        return comp;
    }
}

