/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.shapes;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CachedVoxelShapes<Key> {
    private final Map<Key, VoxelShape> calculatedShapes = new ConcurrentHashMap<Key, VoxelShape>();
    private final Function<Key, List<AABB>> creator;

    public CachedVoxelShapes(Function<Key, List<AABB>> creator) {
        this.creator = creator;
    }

    public VoxelShape get(Key k) {
        return this.calculatedShapes.computeIfAbsent(k, this::calculateShape);
    }

    private VoxelShape calculateShape(Key k) {
        List<AABB> subshapes = this.creator.apply(k);
        VoxelShape ret = Shapes.m_83040_();
        if (subshapes != null) {
            for (AABB aabb : subshapes) {
                ret = Shapes.m_83148_((VoxelShape)ret, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return ret.m_83296_();
    }
}

