/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.mirror;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.mirror.CachedMirroredModel;
import blusunrize.immersiveengineering.client.models.mirror.MirroredModelLoader;
import blusunrize.immersiveengineering.client.models.mirror.MirroredModelState;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public record MirroredGeometry(UnbakedModel inner) implements IModelGeometry<MirroredGeometry>
{
    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLoc) {
        BakedModel baseResult = this.inner.m_7611_(bakery, spriteGetter, (ModelState)new MirroredModelState(modelState), modelLoc);
        if (baseResult instanceof SimpleBakedModel) {
            SimpleBakedModel simpleModel = (SimpleBakedModel)baseResult;
            List<BakedQuad> unculledQuads = MirroredModelLoader.getReversedQuads(simpleModel, null);
            EnumMap<Direction, List<BakedQuad>> culledQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                culledQuads.put(d, MirroredModelLoader.getReversedQuads(simpleModel, d));
            }
            return new SimpleBakedModel(unculledQuads, culledQuads, baseResult.m_7541_(), baseResult.m_7547_(), baseResult.m_7539_(), baseResult.getParticleIcon((IModelData)EmptyModelData.INSTANCE), baseResult.m_7442_(), baseResult.m_7343_());
        }
        if (baseResult instanceof ICacheKeyProvider) {
            ICacheKeyProvider cachedModel = (ICacheKeyProvider)baseResult;
            return new CachedMirroredModel(cachedModel);
        }
        throw new RuntimeException("Tried to mirror model " + this.inner + " which is neither simple nor cacheable");
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.inner.m_5500_(modelGetter, missingTextureErrors);
    }
}

