/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class LightningrodBlockEntity
extends MultiblockPartBlockEntity<LightningrodBlockEntity>
implements IEBlockInterfaces.IBlockBounds {
    private final MutableEnergyStorage energyStorage;
    private final MultiblockCapability<IEnergyStorage> energyCap;
    @Nullable
    private List<BlockPos> fenceNet;
    private int height;

    public LightningrodBlockEntity(BlockEntityType<LightningrodBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.LIGHTNING_ROD, type, false, pos, state);
        this.energyStorage = new MutableEnergyStorage((Integer)IEServerConfig.MACHINES.lightning_output.get());
        this.energyCap = MultiblockCapability.make(this, be -> be.energyCap, MultiblockPartBlockEntity::master, this.registerEnergyOutput(this.energyStorage));
        this.fenceNet = null;
    }

    @Override
    public void tickServer() {
        if (this.energyStorage.getEnergyStored() > 0) {
            for (Direction f : DirectionUtils.BY_HORIZONTAL_INDEX) {
                BlockEntity tileEntity = Utils.getExistingTileEntity(this.f_58857_, this.m_58899_().m_5484_(f, 2));
                int output = EnergyHelper.insertFlux((ICapabilityProvider)tileEntity, f.m_122424_(), this.energyStorage.getMaxEnergyStored(), true);
                output = this.energyStorage.extractEnergy(output, false);
                EnergyHelper.insertFlux((ICapabilityProvider)tileEntity, f.m_122424_(), output, false);
            }
        }
        if (this.f_58857_.m_46467_() % 256L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0xFF)) {
            this.fenceNet = null;
        }
        if (this.fenceNet == null) {
            this.fenceNet = this.getFenceNet();
        }
        if (this.fenceNet != null && this.fenceNet.size() > 0 && this.f_58857_.m_46467_() % 128L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x7F) && (this.f_58857_.m_46470_() || this.f_58857_.m_46471_() && Utils.RAND.nextInt(10) == 0)) {
            int i = this.height + this.fenceNet.size();
            if (Utils.RAND.nextInt(4096 * this.f_58857_.m_151558_()) < i * (this.m_58899_().m_123342_() + i)) {
                this.energyStorage.setStoredEnergy((Integer)IEServerConfig.MACHINES.lightning_output.get());
                BlockPos pos = this.fenceNet.get(Utils.RAND.nextInt(this.fenceNet.size()));
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_58857_);
                lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)pos));
                lightningboltentity.m_20874_(true);
                this.f_58857_.m_7967_((Entity)lightningboltentity);
            }
        }
    }

    @Nullable
    private List<BlockPos> getFenceNet() {
        this.height = 0;
        boolean broken = false;
        BlockPos lastFence = null;
        for (int i = this.m_58899_().m_123342_() + 2; i < this.f_58857_.m_151558_() - 1; ++i) {
            BlockPos pos = new BlockPos(this.m_58899_().m_123341_(), i, this.m_58899_().m_123343_());
            if (!broken && this.isFence(pos)) {
                ++this.height;
                lastFence = pos;
                continue;
            }
            if (!this.f_58857_.m_46859_(pos)) {
                return null;
            }
            if (broken) continue;
            broken = true;
        }
        if (lastFence == null) {
            return null;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        openList.add(lastFence);
        while (!openList.isEmpty() && closedList.size() < 256) {
            BlockPos next = (BlockPos)openList.get(0);
            if (!closedList.contains(next) && this.isFence(next)) {
                closedList.add(next);
                openList.add(next.m_142300_(Direction.WEST));
                openList.add(next.m_142300_(Direction.EAST));
                openList.add(next.m_142300_(Direction.NORTH));
                openList.add(next.m_142300_(Direction.SOUTH));
                openList.add(next.m_142300_(Direction.UP));
            }
            openList.remove(0);
        }
        return closedList;
    }

    private boolean isFence(BlockPos pos) {
        return Utils.isBlockAt(this.f_58857_, pos, (Block)IEBlocks.MetalDecoration.STEEL_FENCE.get());
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (new BlockPos(1, 2, 1).equals((Object)this.posInMultiblock)) {
            return Shapes.m_83048_((double)-0.125, (double)0.0, (double)-0.125, (double)1.125, (double)1.0, (double)1.125);
        }
        if (this.posInMultiblock.m_123341_() == 1 && this.posInMultiblock.m_123343_() == 1 || this.posInMultiblock.m_123342_() < 2 && (this.posInMultiblock.m_123341_() + this.posInMultiblock.m_123343_()) % 2 == 1) {
            return Shapes.m_83144_();
        }
        if (this.posInMultiblock.m_123342_() == 0) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        float xMin = 0.0f;
        float xMax = 1.0f;
        float yMin = 0.0f;
        float yMax = 1.0f;
        float zMin = 0.0f;
        float zMax = 1.0f;
        if (this.posInMultiblock.m_123341_() % 2 == 0 && this.posInMultiblock.m_123343_() % 2 == 0) {
            Direction facing = this.getFacing();
            if (this.posInMultiblock.m_123342_() < 2) {
                yMin = -0.5f;
                yMax = 1.25f;
                float f = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123343_() == 2 ^ facing == Direction.EAST : this.posInMultiblock.m_123341_() == 0 ^ facing == Direction.NORTH) ? 0.1875f : (xMin = 0.5625f);
                float f2 = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123343_() < 2 ^ facing == Direction.EAST : this.posInMultiblock.m_123341_() == 2 ^ facing == Direction.NORTH) ? 0.8125f : (xMax = 0.4375f);
                float f3 = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123341_() == 0 ^ facing == Direction.EAST : this.posInMultiblock.m_123343_() < 2 ^ facing == Direction.NORTH) ? 0.1875f : (zMin = 0.5625f);
                zMax = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123341_() == 2 ^ facing == Direction.EAST : this.posInMultiblock.m_123343_() == 2 ^ facing == Direction.NORTH) ? 0.8125f : 0.4375f;
            } else {
                yMin = 0.25f;
                yMax = 0.75f;
                float f = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123343_() == 2 ^ facing == Direction.EAST : this.posInMultiblock.m_123341_() == 0 ^ facing == Direction.NORTH) ? 0.0f : (xMin = 0.375f);
                float f4 = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123343_() < 2 ^ facing == Direction.EAST : this.posInMultiblock.m_123341_() == 2 ^ facing == Direction.NORTH) ? 1.0f : (xMax = 0.625f);
                float f5 = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123341_() == 0 ^ facing == Direction.EAST : this.posInMultiblock.m_123343_() < 2 ^ facing == Direction.NORTH) ? 0.0f : (zMin = 0.375f);
                zMax = (facing.m_122434_() == Direction.Axis.X ? this.posInMultiblock.m_123341_() == 2 ^ facing == Direction.EAST : this.posInMultiblock.m_123343_() == 2 ^ facing == Direction.NORTH) ? 1.0f : 0.625f;
            }
        } else if (this.posInMultiblock.m_123342_() >= 2) {
            yMin = 0.25f;
            yMax = 0.75f;
            xMin = this.offsetToMaster.m_123341_() < 0 ? 0.375f : 0.0f;
            xMax = this.offsetToMaster.m_123341_() > 0 ? 0.625f : 1.0f;
            zMin = this.offsetToMaster.m_123343_() < 0 ? 0.375f : 0.0f;
            zMax = this.offsetToMaster.m_123343_() > 0 ? 0.625f : 1.0f;
        }
        return Shapes.m_83048_((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && this.isEnergyPos()) {
            return this.energyCap.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    private boolean isEnergyPos() {
        return this.posInMultiblock.m_123342_() == 1 && (this.posInMultiblock.m_123341_() + this.posInMultiblock.m_123343_()) % 2 == 1;
    }
}

