/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.DynamicShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseMinecart;
import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.math.Vector4f;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class IEShaders {
    public static void commonConstruction() {
        IEShaders.setDefaultTextureBounds(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_whitestripe"), 0.0, 0.75, 0.25, 1.0);
        IEShaders.setDefaultTextureBounds(new ResourceLocation("immersiveengineering:item/shaders/drill_diesel_whitestripe"), 0.0, 0.265625, 0.5, 0.65625);
        IEShaders.addShader("rosequartz", 0, Rarity.COMMON, -12508381, -1657676, -995891, -1657676).setInfo(null, null, "rosequartz");
        IEShaders.addShader("argo", 2, Rarity.COMMON, -13816531, -2302756, -2328541, -3618616).setInfo(null, null, "argo");
        IEShaders.addShader("sunstrike", 5, Rarity.RARE, -9211021, -3315456, -1177077248, -1177077248).setInfo(null, null, "sunstrike");
        IEShaders.addShader("locus", 2, Rarity.COMMON, -16119286, -11908534, -8087988, -11908534).setInfo("Mercenaries", "Red vs Blue", "locus");
        IEShaders.addShader("felix", 1, Rarity.COMMON, -16119286, -11908534, -1013757, -11908534).setInfo("Mercenaries", "Red vs Blue", "felix");
        IEShaders.addShader("sharkface", 2, Rarity.UNCOMMON, -16119286, -11908534, -7274488, -11908534, "shark", true, -1).setInfo("Mercenaries", "Red vs Blue", "sharkface");
        IEShaders.addShader("dragonsbreath", 1, Rarity.UNCOMMON, -15132391, -13418709, -7697782, -7697782, "shark", true, -1).setInfo(null, "Destiny", "dragonsbreath");
        IEShaders.addShader("hawk", 3, Rarity.COMMON, -10001557, -725269, -13816531, -725269).setInfo(null, "Destiny", "hawk");
        IEShaders.addShader("eyas", 3, Rarity.COMMON, -11381938, -8771064, -13816531, -725269).setInfo(null, "Destiny", "eyas");
        IEShaders.addShader("magnum", 1, Rarity.COMMON, -11126740, -2302756, -6250336, -2302756).setInfo(null, null, "magnum");
        IEShaders.addShader("fox", 2, Rarity.UNCOMMON, -13816531, -2851279, -1381654, -1381654).setInfo(null, null, "fox");
        IEShaders.addShader("vaulttec", 0, Rarity.COMMON, -11126740, -15054971, -4150704, -5592406).setInfo(null, "Fallout", "vaulttec");
        ShaderRegistry.ShaderRegistryEntry sponsor = IEShaders.addShader("sponsor", 0, Rarity.EPIC, -15132391, -582876, -1, -5592406, "sponsor", false, -1).setInfo(null, "Fallout", "sponsor");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ((ShaderCaseMinecart)sponsor.getCase((ResourceLocation)new ResourceLocation((String)"immersiveengineering", (String)"minecart"))).mirrorSideForPass[2] = false;
            sponsor.getCase(new ResourceLocation("immersiveengineering", "revolver")).getLayers()[4].setTextureBounds(0.0, 0.75, 0.25, 1.0);
            sponsor.getCase(new ResourceLocation("immersiveengineering", "drill")).getLayers()[3].setTextureBounds(0.15625, 0.21875, 0.40625, 0.46875);
            sponsor.getCase(new ResourceLocation("immersiveengineering", "buzzsaw")).getLayers()[3].setTextureBounds(0.03125, 0.515625, 0.359375, 0.84375);
            sponsor.getCase(new ResourceLocation("immersiveengineering", "chemthrower")).getLayers()[3].setTextureBounds(0.09375, 0.5, 0.34375, 0.75);
            sponsor.getCase(new ResourceLocation("immersiveengineering", "shield")).getLayers()[2].setTextureBounds(0.0, 0.21875, 0.4375, 0.71875).setCutoutBounds(0.0625, 0.0, 0.9375, 1.0);
        });
        IEShaders.addShader("massfusion", 3, Rarity.RARE, -9545161, -13023440, -11250604, -5592406, "fusion", true, -1).setInfo(null, "Fallout", "massfusion");
        IEShaders.addShader("stormflower", 1, Rarity.COMMON, -14207961, -14127312, -11824555, -14127312).setInfo(null, "RWBY", "stormflower");
        IEShaders.addShader("milo", 2, Rarity.UNCOMMON, -12903664, -10027004, -3244528, -10027004).setInfo(null, "RWBY", "milo");
        IEShaders.addShader("trident", 2, Rarity.UNCOMMON, -11447983, -5723992, -14035969, -5263441).setInfo(null, "RWBY", "trident");
        IEShaders.addShader("chloris", 4, Rarity.RARE, -13094358, -13094358, -7800130, -3618616).setInfo(null, "RWBY", "chloris");
        IEShaders.addShader("crescentrose", 2, Rarity.COMMON, -15461356, -7274488, -16250872, -5987164).setInfo(null, "RWBY", "crescentrose");
        IEShaders.addShader("qrow", 2, Rarity.UNCOMMON, -9626607, -2566192, -13552064, -9240568).setInfo(null, "RWBY", "qrow");
        ShaderRegistry.ShaderRegistryEntry lususnaturae = IEShaders.addShader("lususnaturae", 0, Rarity.EPIC, -15460071, -15460071, -5393217, -5393217).setInfo(null, "RWBY", "lususnaturae");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IEShaders.addBlockScaledLayer(lususnaturae, "minecraft:block/destroy_stage_8", -1147925492);
            IEShaders.addLayer(lususnaturae, "1_4", -5393217);
        });
        IEShaders.addShader("vanguard", 3, Rarity.UNCOMMON, -13158601, -15525054, -4690924, -2302756).setInfo(null, "Destiny", "vanguard");
        IEShaders.addShader("regal", 4, Rarity.UNCOMMON, -2566959, -12379107, -2566959, -2566959).setInfo(null, "Destiny", "regal");
        IEShaders.addShader("harrowed", 4, Rarity.RARE, -15330527, -12379107, -15330527, -15330527).setInfo(null, "Destiny", "harrowed");
        IEShaders.addShader("taken", 5, Rarity.EPIC, -15655898, -15655898, -4532259, -15655898, null, false, -1).setInfo(null, "Destiny", "taken");
        ShaderRegistry.ShaderRegistryEntry ikelos = IEShaders.addShader("ikelos", 2, Lib.RARITY_MASTERWORK, -9148835, -12434616, -12434616, -13553359).setInfo(null, "Destiny", "ikelos");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IEShaders.addDynamicLayer(ikelos, "circuit", -1072873, (layer, superColour) -> ClientUtils.pulseRGBAlpha(superColour, 40, 0.15f, 1.0f), pre -> {}, true);
            IEShaders.addLayer(ikelos, "1_4", -10525590);
            ikelos.setEffectFunction((world, shader, item, shaderType, pos, dir, scale) -> {
                ImmersiveEngineering.proxy.spawnFractalFX(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, dir != null ? dir : new Vec3(0.0, 1.0, 0.0), scale, 2, null);
                ImmersiveEngineering.proxy.spawnFractalFX(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, dir != null ? dir : new Vec3(0.0, 0.0, 1.0), scale, 2, null);
                ImmersiveEngineering.proxy.spawnFractalFX(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, dir != null ? dir : new Vec3(1.0, 0.0, 0.0), scale, 2, null);
            });
        });
        IEShaders.addShader("angelsthesis", 2, Rarity.EPIC, -14803426, -9091433, -8931011, -11513776, null, false, -1).setInfo("Mecha", "Neon Genesis Evangelion", "angelsthesis");
        IEShaders.addShader("sutherland", 0, Rarity.RARE, -12304305, -9740626, -9427143, -12304305, "whitestripe", true, -9428940).setInfo("Mecha", "Code Geass", "sutherland");
        IEShaders.addShader("exia", 8, Rarity.RARE, -5103092, -11177518, -1251359, -4129337, "whitestripe", true, -4157390).setInfo("Mecha", "Gundam 00", "exia");
        IEShaders.addShader("crimsonlotus", 3, Lib.RARITY_MASTERWORK, -2608583, -2608583, -11645101, -13635209, "whitestripe", true, -738991).setInfo("Mecha", "Gurren Lagann", "crimsonlotus");
        IEShaders.addShader("dominator", 1, Rarity.UNCOMMON, -11783905, -14013386, -10747909, -14013386, "1_3", true, -14013386).setInfo(null, "Psycho-Pass", "dominator");
        IEShaders.addShader("warbird", 7, Rarity.UNCOMMON, -13552064, -2566192, -1332224, -2566192).setInfo(null, null, "warbird");
        IEShaders.addShader("matrix", 7, Rarity.RARE, -16433348, -1973761, -2818049, -1, "pipes", true, -8069672).setInfo(null, null, "matrix");
        IEShaders.addShader("twili", 5, Rarity.EPIC, -11182736, -15065557, -14538951, -14830194, "circuit", false, -14830194).setInfo(null, "The Legend of Zelda: Twilight Princess", "twili");
        IEShaders.addShader("usurper", 3, Rarity.EPIC, -12706274, -10722986, -15658992, -9209236, "circuit", false, -3526856).setInfo(null, "The Legend of Zelda: Twilight Princess", "usurper");
        ShaderRegistry.ShaderRegistryEntry ancient = IEShaders.addShader("ancient", 6, Lib.RARITY_MASTERWORK, -6538707, -11450296, -610742, -8323854).setInfo(null, "The Legend of Zelda: Breath of the Wild", "ancient");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IEShaders.addDynamicLayer(ancient, "1_6", -8323854, (layer, superColour) -> ClientUtils.pulseRGBAlpha(superColour, 60, 0.05f, 0.5f), pre -> {}, true);
            IEShaders.addLayer(ancient, "circuit", -1715694729);
            ((ShaderCaseDrill)ancient.getCase(new ResourceLocation("immersiveengineering", "drill"))).addHeadLayers(new ShaderLayer(new ResourceLocation("immersiveengineering", "item/drill_iron"), -8323854));
        });
        IEShaders.addShader("glacis", 6, Rarity.RARE, -11953214, 863424761, 868089853, 868089853).setInfo(null, null, "glacis");
        IEShaders.addShader("phoenix", 5, Rarity.RARE, -9109504, -3145728, -33024, -33024).setInfo(null, null, "phoenix");
        IEShaders.addShader("radiant", 3, Rarity.UNCOMMON, -6066517, -468036, -3695951, -2565917, "pipes", true, -931554).setInfo(null, "Kingdom Hearts", "radiant");
        IEShaders.addShader("hollow", 4, Rarity.UNCOMMON, -11260644, -1128987, -3372672, -3890774, "pipes", true, -3893192).setInfo(null, "Kingdom Hearts", "hollow");
        IEShaders.addShader("microshark", 8, Rarity.RARE, -8957868, -526641, -7118233, -7118233, "shark", true, -1).setInfo(null, "Terraria", "microshark");
        IEShaders.addShader("n7", 2, Rarity.EPIC, -15526117, -11383478, -2090727, -7698812, "whitestripe", false, -1).setInfo(null, "Mass Effect", "n7");
        IEShaders.addShader("normandy", 8, Rarity.RARE, -1, -15066598, -1, -1, "whitestripe", true, -13286274).setInfo(null, "Mass Effect", "normandy");
        IEShaders.addShader("omnitool", 2, Rarity.RARE, 1090491692, 822056236, 1090491692, 553620780).setInfo(null, "Mass Effect", "omnitool");
        ShaderRegistry.ShaderRegistryEntry kindled = IEShaders.addShader("kindled", 5, Rarity.EPIC, -13953525, -12961222, -2134944737, -11579569).setInfo(null, "Dark Souls", "kindled");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addBlockScaledLayer(kindled, "minecraft:block/fire_0", -2130706433));
        ShaderRegistry.ShaderRegistryEntry darkfire = IEShaders.addShader("darkfire", 5, Rarity.EPIC, -14806245, -14608845, -13432814, -12506779).setInfo(null, "Kingdom Hearts", "darkfire");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addBlockScaledLayer(darkfire, "immersiveengineering:block/shaders/greyscale_fire", -6388757));
        ShaderRegistry.ShaderRegistryEntry erruption = IEShaders.addShader("erruption", 5, Rarity.RARE, -13953525, -10992849, -2134953953, -10992849).setInfo(null, null, "erruption");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addBlockScaledLayer(erruption, "minecraft:block/destroy_stage_8", -40172));
        IEShaders.addShader("waaagh", 5, Rarity.RARE, -15790321, -2185454, -4105463, -13684945, "1_7", true, -13684945).setInfo(null, "Warhammer 40k", "waaagh");
        ShaderRegistry.ShaderRegistryEntry astartes = IEShaders.addShader("astartes", 3, Rarity.RARE, -14605271, -7457996, -8683897, -8683897).setInfo(null, "Warhammer 40k", "astartes");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addLayer(astartes, "1_8", -7457996));
        ShaderRegistry.ShaderRegistryEntry netherforged = IEShaders.addShader("netherforged", 0, Rarity.EPIC, -11055034, -13485012, -2134944737, -11579569).setInfo(null, null, "netherforged");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IEShaders.addBlockScaledLayer(netherforged, "minecraft:block/magma", -1);
            netherforged.getCase(new ResourceLocation("immersiveengineering", "revolver")).getLayers()[4].setTextureBounds(0.0, 0.6875, 0.3125, 1.0);
            IEShaders.addLayer(netherforged, "1_8", -13485012);
            netherforged.getCase(new ResourceLocation("immersiveengineering", "revolver")).getLayers()[5].setTextureBounds(0.0, 0.8125, 1.0, 1.0).setCutoutBounds(0.0, 0.0, 1.0, 0.1875);
            IEShaders.addLayer(netherforged, "1_0", -13485012);
        });
        IEShaders.addShader("transpride", 2, Rarity.EPIC, -676935, -10760198, -676935, -1, "whitestripe", true, -1).setInfo("Pride", "Pride Flags", "transpride");
        ShaderRegistry.ShaderRegistryEntry enbypride = IEShaders.addShader("enbypride", 8, Rarity.EPIC, -14145496, -14145496, -6465070, -1, "1_2", true, -199631).setInfo("Pride", "Pride Flags", "enbypride");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addLayer(enbypride, "whitestripe", -1));
        ShaderRegistry.ShaderRegistryEntry gaypride = IEShaders.addShader("gaypride", 8, Rarity.EPIC, -11515444, -14233942, -8671774, 0xFFFFFF, "whitestripe", true, -1).setInfo("Pride", "Pride Flags", "gaypride");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addLayer(gaypride, "1_3", -6756122));
        ShaderRegistry.ShaderRegistryEntry lesbianpride = IEShaders.addShader("lesbianpride", 8, Rarity.EPIC, -5963678, -2858331, -25771, -5963678, "1_2", true, -2742016).setInfo("Pride", "Pride Flags", "lesbianpride");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addLayer(lesbianpride, "whitestripe", -1));
        IEShaders.addShader("bipride", 8, Rarity.EPIC, -16763479, -6533481, -2686863, -16763479).setInfo("Pride", "Pride Flags", "bipride");
        ShaderRegistry.ShaderRegistryEntry acepride = IEShaders.addShader("acepride", 8, Rarity.EPIC, -11468717, -1, -9671572, -9671572, "1_2", true, -16777216).setInfo("Pride", "Pride Flags", "acepride");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IEShaders.addLayer(acepride, "whitestripe", -11468717));
    }

    public static ShaderRegistry.ShaderRegistryEntry addShader(String name, int overlayType, Rarity rarity, int colourBackground, int colourPrimary, int colourSecondary, int colourBlade) {
        return IEShaders.addShader(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, null, true, -1);
    }

    public static ShaderRegistry.ShaderRegistryEntry addShader(String name, int overlayType, Rarity rarity, int colourBackground, int colourPrimary, int colourSecondary, int colourBlade, String additionalTexture, boolean loot, int colourOverlay) {
        return ShaderRegistry.registerShader(new ResourceLocation("immersiveengineering", name), Integer.toString(overlayType), rarity, colourPrimary, colourSecondary, colourBackground, colourBlade, additionalTexture, colourOverlay, loot, true);
    }

    private static void addBlockScaledLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour) {
        entry.getCase(new ResourceLocation("immersiveengineering", "revolver")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.8125, 0.25, 1.0));
        entry.getCase(new ResourceLocation("immersiveengineering", "drill")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.15625, 0.21875, 0.40625, 0.46875).setCutoutBounds(0.1875, 0.0, 0.8125, 0.75));
        entry.getCase(new ResourceLocation("immersiveengineering", "buzzsaw")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.6875, 0.40625, 0.84375).setCutoutBounds(0.0, 0.615, 1.0, 1.0));
        entry.getCase(new ResourceLocation("immersiveengineering", "chemthrower")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.09375, 0.625, 0.34375, 0.75).setCutoutBounds(0.0, 0.0, 1.0, 0.5));
        entry.getCase(new ResourceLocation("immersiveengineering", "railgun")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.859375, 0.09375, 1.0, 0.25).setCutoutBounds(0.25, 0.125, 0.75, 0.6875));
        entry.getCase(new ResourceLocation("immersiveengineering", "shield")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.1875, 0.4375, 0.71875).setCutoutBounds(0.0625, 0.0, 0.9375, 1.0));
        entry.getCase(new ResourceLocation("immersiveengineering", "balloon")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.0, 0.125, 0.75, 0.625).setCutoutBounds(0.125, 0.0, 0.875, 0.5));
        entry.getCase(new ResourceLocation("immersiveengineering", "banner")).addLayers(new ShaderLayer(new ResourceLocation(texture), colour).setTextureBounds(0.015625, 0.359375, 0.328125, 0.671875));
    }

    private static void addLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour) {
        entry.getCase(new ResourceLocation("immersiveengineering", "revolver")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "drill")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/drill_diesel_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "buzzsaw")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/buzzsaw_diesel_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "chemthrower")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/chemthrower_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "railgun")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/railgun_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "shield")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/shield_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "minecart")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_" + texture + ".png"), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "balloon")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:block/shaders/balloon_" + texture), colour));
        entry.getCase(new ResourceLocation("immersiveengineering", "banner")).addLayers(new ShaderLayer(new ResourceLocation("immersiveengineering:block/shaders/banner_" + texture), colour));
    }

    private static void addDynamicLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour, BiFunction<ShaderLayer, Vector4f, Vector4f> func_getColour, Consumer<Boolean> func_modifyRender) {
        IEShaders.addDynamicLayer(entry, texture, colour, func_getColour, func_modifyRender, false);
    }

    private static void addDynamicLayer(ShaderRegistry.ShaderRegistryEntry entry, String texture, int colour, BiFunction<ShaderLayer, Vector4f, Vector4f> func_getColour, Consumer<Boolean> func_modifyRender, boolean translucent) {
        entry.getCase(new ResourceLocation("immersiveengineering", "revolver")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "drill")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/drill_diesel_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "buzzsaw")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/buzzsaw_diesel_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "chemthrower")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/chemthrower_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "railgun")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/railgun_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "shield")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:item/shaders/shield_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "minecart")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_" + texture + ".png"), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "balloon")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:block/shaders/balloon_" + texture), colour, func_getColour, func_modifyRender, translucent));
        entry.getCase(new ResourceLocation("immersiveengineering", "banner")).addLayers(new InternalDynamicShaderLayer(new ResourceLocation("immersiveengineering:block/shaders/banner_" + texture), colour, func_getColour, func_modifyRender, translucent));
    }

    public static void setDefaultTextureBounds(ResourceLocation rl, double ... bounds) {
        ShaderRegistry.defaultLayerBounds.put(rl, bounds);
    }

    private static class InternalDynamicShaderLayer
    extends DynamicShaderLayer {
        private final BiFunction<ShaderLayer, Vector4f, Vector4f> func_getColour;
        private final Consumer<Boolean> func_modifyRender;
        private final boolean translucent;

        public InternalDynamicShaderLayer(ResourceLocation texture, int colour, BiFunction<ShaderLayer, Vector4f, Vector4f> func_getColour, Consumer<Boolean> func_modifyRender, boolean translucent) {
            super(texture, colour);
            this.func_getColour = func_getColour;
            this.func_modifyRender = func_modifyRender;
            this.translucent = translucent;
        }

        @Override
        public Vector4f getColor() {
            if (this.func_getColour != null) {
                return this.func_getColour.apply(this, super.getColor());
            }
            return super.getColor();
        }

        @Override
        public RenderType getRenderType(RenderType base) {
            if (this.func_modifyRender == null) {
                return base;
            }
            return new RenderType("shader_" + base.toString() + this.func_modifyRender, base.m_110508_(), base.m_173186_(), 256, base.m_110405_(), true, () -> {
                base.m_110185_();
                this.func_modifyRender.accept(true);
            }, () -> {
                this.func_modifyRender.accept(false);
                base.m_110188_();
            }){};
        }

        @Override
        public boolean isTranslucent() {
            return this.translucent;
        }
    }
}

