/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IForgeUnit<U>
extends IHaveConfig,
IForgeRegistryEntry<U> {
    public static UnitConfig createConfig(AbstractForgeMod mod, String folder, Class<?> clazz) {
        Path baseDir = mod.getConfigsDir().resolve(folder);
        String configName = IForgeUnit.getClassRegName(clazz);
        return UnitConfig.in(baseDir, configName);
    }

    public static String getClassRegName(Class<?> clazz) {
        return UnitId.dictToRegName(clazz.getSimpleName());
    }

    default public String getClassRegName() {
        return IForgeUnit.getClassRegName(this.getClass());
    }

    default public String getUnitCategory() {
        return Objects.requireNonNull(this.getRegistryName()).m_135815_();
    }

    default public boolean isServerSide(LevelReader level) {
        return GameWorld.isServerSide(level);
    }

    default public boolean isClientSide(LevelReader level) {
        return GameWorld.isClientSide(level);
    }

    public boolean isEnabled();

    public static enum Variants implements IForgeEnum
    {
        NORMAL,
        INVENTORY;

    }
}

