/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.units.IForgeUnit;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.common.util.Lazy;

public abstract class UnitsInit<U>
implements IPostInit {
    private final AbstractForgeMod mod;
    protected final Set<Lazy<? extends U>> units = new HashSet<Lazy<? extends U>>();

    public UnitsInit(AbstractForgeMod mod) {
        this.mod = mod;
        mod.runDuringPostInit(this::onPostInit);
    }

    public <E extends U> Lazy<E> addNew(Supplier<E> supplier) {
        Lazy unit = Lazy.of(supplier);
        this.units.add(unit);
        return unit;
    }

    protected void removeAll() {
        this.units.clear();
    }

    @Override
    public void onPostInit() {
        this.streamAll().forEach(unit -> {
            if (unit instanceof IPostInit) {
                IPostInit init = (IPostInit)unit;
                init.onPostInit();
            }
            if (unit instanceof IHaveConfig) {
                IHaveConfig config = (IHaveConfig)unit;
                config.saveConfig();
            }
        });
    }

    public Set<Supplier<? extends U>> getAll() {
        return Collections.unmodifiableSet(this.units);
    }

    public Stream<U> streamAll() {
        return this.units.stream().map(Supplier::get);
    }

    public AbstractForgeMod getMod() {
        return this.mod;
    }

    public static Path getConfigsDir(AbstractForgeMod mod, Class<?> clazz) {
        return mod.getConfigsDir().resolve(clazz.getSimpleName());
    }

    public Path getConfigsDir() {
        return UnitsInit.getConfigsDir(this.getMod(), this.getClass());
    }

    public UnitConfig createConfigFor(Class<? extends U> clazz) {
        return UnitConfig.in(this.getConfigsDir(), IForgeUnit.getClassRegName(clazz));
    }
}

