function initializeCoreMod() {
    Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/level/block/CampfireBlock',
		'methodName' : resolveName('m_51251_'), // makeParticles
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ZZ)V'
	}
	
	var handler = {
		'class': 'com/endertech/minecraft/forge/events/CampfireSmokeEvent',
		'methodName': 'onCampfireSmokeSpawn',
		'methodDesc': '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ZZ)Z'
	}

    var instructions = [
		insnLoadObj(0, "level"),
		insnLoadObj(1, "pos"),
		insnLoadInt(2, "isSignalFire"),
		insnLoadInt(3, "spawnExtraSmoke"),
		insnCallHandler(handler)
	];
    
	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}