/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy.network;

import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.network.EnergyNetworkManager;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class EnergyNetwork {
    private int id;
    private int inBuff = 0;
    private int inDemand = 0;
    private int outBuff = 0;
    private int outBuffRetained = 0;
    private int outDemand = 0;
    private boolean valid = true;
    private int pulled = 0;
    private int pushed = 0;
    private static int MAX_BUFF = 10000;

    public EnergyNetwork(Level world) {
        EnergyNetworkManager.instances.get(world).add(this);
    }

    public void tick(int index) {
        this.id = index;
        int t = this.outBuff;
        this.outBuffRetained = this.outBuff = this.inBuff;
        this.inBuff = t;
        this.outDemand = this.inDemand;
        this.inDemand = 0;
        this.pulled = 0;
        this.pushed = 0;
    }

    public int getBuff() {
        return this.outBuffRetained;
    }

    public int push(int energy) {
        energy = (energy = Math.min(MAX_BUFF - this.inBuff, energy)) > 0 ? energy : 0;
        this.inBuff += energy;
        this.pushed += energy;
        return energy;
    }

    public int demand(int demand) {
        this.inDemand += demand;
        return demand;
    }

    public int getDemand() {
        return this.outDemand;
    }

    public int getPulled() {
        return this.pulled;
    }

    public int getPushed() {
        return this.pushed;
    }

    public int pull(int max) {
        int r = (int)((double)Math.max(Math.min(max, this.outBuff), 0));
        this.outBuff -= r;
        this.pulled += r;
        return r;
    }

    public static EnergyNetwork nextNode(Level world, EnergyNetwork en, Map<String, IWireNode> visited, IWireNode current, int index) {
        if (visited.containsKey(EnergyNetwork.posKey(current.getMyPos(), index))) {
            return null;
        }
        current.setNetwork(index, en);
        visited.put(EnergyNetwork.posKey(current.getMyPos(), index), current);
        for (int i = 0; i < current.getNodeCount(); ++i) {
            IWireNode next = current.getNode(i);
            if (next == null || !current.isNodeIndeciesConnected(index, i)) continue;
            EnergyNetwork.nextNode(world, en, visited, next, current.getOtherNodeIndex(i));
        }
        return en;
    }

    private static String posKey(BlockPos pos, int index) {
        return pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + ":" + index;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void removed() {
    }

    public int getId() {
        return this.id;
    }
}

