/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import mezz.jei.color.MMCQ;
import org.jetbrains.annotations.Nullable;

public class ColorThief {
    public static int[][] getPalette(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount, quality, ignoreWhite);
        if (cmap == null) {
            return new int[0][0];
        }
        return cmap.palette();
    }

    @Nullable
    public static MMCQ.CMap getColorMap(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        if (sourceImage.m_85102_() == NativeImage.Format.RGBA) {
            int[][] pixelArray = ColorThief.getPixels(sourceImage, quality, ignoreWhite);
            return MMCQ.quantize(pixelArray, colorCount);
        }
        return null;
    }

    private static int[][] getPixels(NativeImage sourceImage, int quality, boolean ignoreWhite) {
        int width = sourceImage.m_84982_();
        int height = sourceImage.m_85084_();
        int pixelCount = width * height;
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        int i = 0;
        while (i < pixelCount) {
            int x = i % width;
            int y = i / width;
            int rgba = sourceImage.m_84985_(x, y);
            int a = rgba >> 24 & 0xFF;
            int b = rgba >> 16 & 0xFF;
            int g = rgba >> 8 & 0xFF;
            int r = rgba & 0xFF;
            if (!(a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250)) {
                pixelArray[numUsedPixels] = new int[]{r, g, b};
                ++numUsedPixels;
                i += quality;
                continue;
            }
            ++i;
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }
}

