/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.ai.HybridPathNavigator;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IContainerEntity;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.init.ModSoundEvents;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import dev.itsmeow.betteranimalsplus.mixin.DamageSourceInvoker;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityWalrus
extends Animal
implements IContainerEntity<EntityWalrus> {
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(EntityWalrus.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<BlockPos> TRAVEL_POS = SynchedEntityData.m_135353_(EntityWalrus.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(EntityWalrus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRAVELLING = SynchedEntityData.m_135353_(EntityWalrus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean advancementGiven = false;

    public EntityWalrus(EntityType<? extends EntityWalrus> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveHelperController(this);
        this.f_19793_ = 1.0f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.advancementGiven && stack.m_41720_() == ModItems.FRIED_EGG.get()) {
            this.m_142075_(player, hand, stack);
            this.f_19853_.m_7605_((Entity)this, (byte)90);
            this.advancementGiven = true;
            if (player instanceof ServerPlayer) {
                ModTriggers.WALRUS_EASTER_EGG.trigger((ServerPlayer)player);
            }
            this.m_5496_((SoundEvent)ModSoundEvents.WALRUS_TUNE.get(), 1.0f, 1.0f);
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 1.0, 1.0, 1.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 90) {
            for (int i = 0; i < 7; ++i) {
                double x = this.f_19796_.nextGaussian() * 0.02;
                double y = this.f_19796_.nextGaussian() * 0.02;
                double z = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), x, y, z);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(this.m_21187_().nextInt(3) == 0 ? ((DamageSourceInvoker)DamageSource.m_19370_((LivingEntity)this)).invokeBypassArmor() : DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        if (flag) {
            Vec3 pos = this.m_20182_();
            Vec3 targetPos = entityIn.m_20182_();
            ((LivingEntity)entityIn).m_147240_(0.5, pos.f_82479_ - targetPos.f_82479_, pos.f_82481_ - targetPos.f_82481_);
        }
        return flag;
    }

    public void setHome(BlockPos position) {
        this.f_19804_.m_135381_(HOME_POS, (Object)position);
    }

    private BlockPos getHome() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    private void setTravelPos(BlockPos position) {
        this.f_19804_.m_135381_(TRAVEL_POS, (Object)position);
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.f_19804_.m_135370_(TRAVEL_POS);
    }

    private boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    private void setGoingHome(boolean isGoingHome) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)isGoingHome);
    }

    private boolean isTravelling() {
        return (Boolean)this.f_19804_.m_135370_(TRAVELLING);
    }

    private void setTravelling(boolean isTravelling) {
        this.f_19804_.m_135381_(TRAVELLING, (Object)isTravelling);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(TRAVEL_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOING_HOME, (Object)false);
        this.f_19804_.m_135372_(TRAVELLING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("HomePosX", this.getHome().m_123341_());
        compound.m_128405_("HomePosY", this.getHome().m_123342_());
        compound.m_128405_("HomePosZ", this.getHome().m_123343_());
        compound.m_128405_("TravelPosX", this.getTravelPos().m_123341_());
        compound.m_128405_("TravelPosY", this.getTravelPos().m_123342_());
        compound.m_128405_("TravelPosZ", this.getTravelPos().m_123343_());
        compound.m_128379_("DiscGiven", this.advancementGiven);
    }

    public void m_7378_(CompoundTag compound) {
        int i = compound.m_128451_("HomePosX");
        int j = compound.m_128451_("HomePosY");
        int k = compound.m_128451_("HomePosZ");
        this.setHome(new BlockPos(i, j, k));
        super.m_7378_(compound);
        int l = compound.m_128451_("TravelPosX");
        int i1 = compound.m_128451_("TravelPosY");
        int j1 = compound.m_128451_("TravelPosZ");
        this.setTravelPos(new BlockPos(l, i1, j1));
        this.advancementGiven = compound.m_128471_("DiscGiven");
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.setHome(this.m_142538_());
        this.setTravelPos(BlockPos.f_121853_);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean canSpawn(EntityType<EntityWalrus> walrus, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return pos.m_123342_() < world.m_5736_() + 4 && world.m_45524_(pos, 0) > 8;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new GoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new GoHomeGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TravelGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected double m_6639_(LivingEntity attackTarget) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + attackTarget.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WanderGoal(this, 1.0, 100));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return EntityWalrus.this.f_19853_.m_46791_() != Difficulty.PEACEFUL && super.m_8036_();
            }
        });
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return false;
    }

    public int m_6062_() {
        return 6000;
    }

    protected int m_7305_(int currentAir) {
        return this.m_6062_();
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 0.6f);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.15f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new HybridPathNavigator<EntityWalrus>(this, worldIn, EntityWalrus::isTravelling);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        if (!this.isGoingHome() && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return 10.0f;
        }
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13047_) ? 10.0f : worldIn.m_46863_(pos) - 0.5f;
    }

    public void m_7023_(Vec3 p_213352_1_) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, p_213352_1_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!(this.m_5448_() != null || this.isGoingHome() && this.getHome().m_123314_((Vec3i)this.m_142538_(), 20.0))) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_213352_1_);
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return null;
    }

    public boolean m_6785_(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityWalrus getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<? extends EntityWalrus> getContainer() {
        return ModEntities.WALRUS;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityWalrus walrus;

        MoveHelperController(EntityWalrus walrus) {
            super((Mob)walrus);
            this.walrus = walrus;
        }

        private void updateSpeed() {
            if (this.walrus.m_20069_()) {
                this.walrus.m_20256_(this.walrus.m_20184_().m_82520_(0.0, 0.005, 0.0));
                if (!this.walrus.getHome().m_123314_((Vec3i)this.walrus.m_142538_(), 16.0)) {
                    this.walrus.m_7910_(Math.max(this.walrus.m_6113_() / 2.0f, 0.2f));
                }
            } else if (this.walrus.f_19861_) {
                this.walrus.m_7910_(Math.max(this.walrus.m_6113_() / 2.0f, 0.06f));
            }
        }

        public void m_8126_() {
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.walrus.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.walrus.m_20185_();
                double d1 = this.f_24976_ - this.walrus.m_20186_();
                double d2 = this.f_24977_ - this.walrus.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.walrus.m_146922_(this.m_24991_(this.walrus.m_146908_(), f, 90.0f));
                this.walrus.f_20883_ = this.walrus.m_146908_();
                float f1 = (float)(this.f_24978_ * this.walrus.m_21051_(Attributes.f_22279_).m_22135_());
                this.walrus.m_7910_(Mth.m_14179_((float)0.125f, (float)this.walrus.m_6113_(), (float)f1));
                this.walrus.m_20256_(this.walrus.m_20184_().m_82520_(0.0, (double)this.walrus.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.walrus.m_7910_(0.0f);
            }
        }
    }

    public static class GoToWaterGoal
    extends MoveToBlockGoal {
        private final EntityWalrus walrus;

        public GoToWaterGoal(EntityWalrus walrus, double speed) {
            super((PathfinderMob)walrus, speed, 24);
            this.walrus = walrus;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.walrus.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.walrus.f_19853_, this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.walrus.m_6162_() && !this.walrus.m_20069_()) {
                return super.m_8036_();
            }
            return !this.walrus.isGoingHome() && !this.walrus.m_20069_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            Block block = worldIn.m_8055_(pos).m_60734_();
            return block == Blocks.f_49990_;
        }
    }

    public static class GoHomeGoal
    extends Goal {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;
        private int ticksRan;

        public GoHomeGoal(EntityWalrus walrus, double speedIn) {
            this.walrus = walrus;
            this.speed = speedIn;
        }

        public boolean m_8036_() {
            if (this.walrus.m_6162_()) {
                return false;
            }
            if (this.walrus.m_21187_().nextInt(700) != 0) {
                return false;
            }
            return !this.walrus.getHome().m_123314_((Vec3i)this.walrus.m_142538_(), 64.0);
        }

        public void m_8056_() {
            this.walrus.setGoingHome(true);
            this.noPosition = false;
            this.ticksRan = 0;
        }

        public void m_8041_() {
            this.walrus.setGoingHome(false);
        }

        public boolean m_8045_() {
            return !this.walrus.getHome().m_123314_((Vec3i)this.walrus.m_142538_(), 7.0) && !this.noPosition && this.ticksRan <= 600;
        }

        public void m_8037_() {
            BlockPos blockpos = this.walrus.getHome();
            boolean nearHome = blockpos.m_123314_((Vec3i)this.walrus.m_142538_(), 16.0);
            if (nearHome) {
                ++this.ticksRan;
            }
            if (this.walrus.m_21573_().m_26571_()) {
                Vec3 vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.walrus, (int)16, (int)3, (Vec3)new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), (double)0.3141592653589793);
                if (vec3d == null) {
                    vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.walrus, (int)8, (int)7, (Vec3)new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), (double)1.5707963267948966);
                }
                if (vec3d != null && !nearHome && this.walrus.f_19853_.m_8055_(new BlockPos(vec3d)).m_60734_() != Blocks.f_49990_) {
                    vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.walrus, (int)16, (int)5, (Vec3)new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), (double)1.5707963267948966);
                }
                if (vec3d == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, this.speed);
            }
        }
    }

    public static class TravelGoal
    extends Goal {
        private final EntityWalrus walrus;
        private final double speed;
        private boolean noPosition;

        public TravelGoal(EntityWalrus walrus, double speed) {
            this.walrus = walrus;
            this.speed = speed;
        }

        public boolean m_8036_() {
            return !this.walrus.isGoingHome() && this.walrus.m_20069_();
        }

        public void m_8056_() {
            int xzRange = 512;
            int yRange = 4;
            Random random = this.walrus.f_19796_;
            int xOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            int yOff = random.nextInt(yRange * 2 + 1) - yRange;
            int zOff = random.nextInt(xzRange * 2 + 1) - xzRange;
            if ((double)yOff + this.walrus.m_20186_() > (double)(this.walrus.f_19853_.m_5736_() - 1)) {
                yOff = 0;
            }
            BlockPos blockpos = new BlockPos((double)xOff + this.walrus.m_20185_(), (double)yOff + this.walrus.m_20186_(), (double)zOff + this.walrus.m_20189_());
            this.walrus.setTravelPos(blockpos);
            this.walrus.setTravelling(true);
            this.noPosition = false;
        }

        public void m_8037_() {
            if (this.walrus.m_21573_().m_26571_()) {
                int z;
                int range;
                int x;
                BlockPos blockpos = this.walrus.getTravelPos();
                Vec3 dest = DefaultRandomPos.m_148412_((PathfinderMob)this.walrus, (int)16, (int)3, (Vec3)new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), (double)0.3141592653589793);
                if (dest == null) {
                    dest = DefaultRandomPos.m_148412_((PathfinderMob)this.walrus, (int)8, (int)7, (Vec3)new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), (double)1.5707963267948966);
                }
                if (dest != null && !this.walrus.f_19853_.m_46812_((x = Mth.m_14107_((double)dest.f_82479_)) - (range = 34), 0, (z = Mth.m_14107_((double)dest.f_82481_)) - range, x + range, 0, z + range)) {
                    dest = null;
                }
                if (dest == null) {
                    this.noPosition = true;
                    return;
                }
                this.walrus.m_21573_().m_26519_(dest.f_82479_, dest.f_82480_, dest.f_82481_, this.speed);
            }
        }

        public boolean m_8045_() {
            return !this.walrus.m_21573_().m_26571_() && !this.noPosition && !this.walrus.isGoingHome();
        }

        public void m_8041_() {
            this.walrus.setTravelling(false);
            super.m_8041_();
        }
    }

    public static class WanderGoal
    extends RandomStrollGoal {
        private final EntityWalrus walrus;

        public WanderGoal(EntityWalrus walrus, double speed, int chance) {
            super((PathfinderMob)walrus, speed, chance);
            this.walrus = walrus;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && !this.walrus.isGoingHome() && super.m_8036_();
        }
    }
}

