/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib;

import cc.tweaked.internal.cobalt.Buffer;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.lib.FormatDesc;

class StringFormat {
    StringFormat() {
    }

    static Varargs format(LuaState state, FormatState format) throws LuaError, UnwindThrowable {
        LuaString fmt = format.format;
        int n = fmt.length();
        Buffer result = format.buffer;
        int i = format.i;
        block9: while (i < n) {
            int c;
            if ((c = fmt.luaByte(i++)) != 37) {
                result.append((byte)c);
                continue;
            }
            if (i >= n) {
                throw new LuaError("invalid option '%' to 'format'");
            }
            if (fmt.luaByte(i) == 37) {
                ++i;
                result.append((byte)37);
                continue;
            }
            LuaValue value = format.args.arg(++format.arg);
            FormatDesc fdsc = new FormatDesc(fmt, i);
            i += fdsc.length;
            switch (fdsc.conversion) {
                case 99: {
                    fdsc.format(result, (byte)value.checkLong());
                    continue block9;
                }
                case 88: 
                case 100: 
                case 105: 
                case 111: 
                case 117: 
                case 120: {
                    fdsc.format(result, value.checkLong());
                    continue block9;
                }
                case 69: 
                case 71: 
                case 101: 
                case 102: 
                case 103: {
                    fdsc.format(result, value.checkDouble());
                    continue block9;
                }
                case 113: {
                    StringFormat.addQuoted(result, format.arg, value);
                    continue block9;
                }
                case 115: {
                    try {
                        StringFormat.addString(result, fdsc, OperationHelper.checkToString(OperationHelper.toString(state, value)));
                        continue block9;
                    }
                    catch (UnwindThrowable e) {
                        format.current = fdsc;
                        format.i = i;
                        throw e;
                    }
                }
            }
            throw new LuaError("invalid option '%" + (char)fdsc.conversion + "' to 'format'");
        }
        return result.toLuaString();
    }

    static void addString(Buffer result, FormatDesc fdsc, LuaString s) {
        if (fdsc.precision == -1 && s.length() >= 100) {
            result.append(s);
        } else {
            fdsc.format(result, s);
        }
    }

    private static void addQuoted(Buffer buf, int arg, LuaValue s) throws LuaError {
        switch (s.type()) {
            case 4: {
                StringFormat.addQuoted(buf, s.checkLuaString());
                break;
            }
            case 3: {
                if (s instanceof LuaInteger) {
                    buf.append(Integer.toString(s.checkInteger()));
                    break;
                }
                double value = s.checkDouble();
                buf.append((double)((long)value) == value ? Long.toString((long)value) : Double.toHexString(value));
                break;
            }
            case 0: 
            case 1: {
                buf.append(s.toString());
                break;
            }
            default: {
                throw ErrorFactory.argError(arg, "value has no literal representation");
            }
        }
    }

    private static void addQuoted(Buffer buf, LuaString s) {
        buf.append((byte)34);
        int n = s.length();
        block5: for (int i = 0; i < n; ++i) {
            int c = s.luaByte(i);
            switch (c) {
                case 10: 
                case 34: 
                case 92: {
                    buf.append((byte)92);
                    buf.append((byte)c);
                    continue block5;
                }
                case 13: {
                    buf.append("\\r");
                    continue block5;
                }
                case 0: {
                    buf.append("\\000");
                    continue block5;
                }
                default: {
                    buf.append((byte)c);
                }
            }
        }
        buf.append((byte)34);
    }

    static class FormatState {
        final LuaString format;
        int i = 0;
        final Buffer buffer;
        int arg = 1;
        final Varargs args;
        FormatDesc current;

        FormatState(LuaString format, Buffer buffer, Varargs args) {
            this.args = args;
            this.format = format;
            this.buffer = buffer;
        }
    }
}

