/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.metrics;

import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.metrics.ComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.basic.BasicComputerMetricsObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public final class GlobalMetrics {
    volatile boolean enabled = false;
    final Object lock = new Object();
    final List<ComputerMetricsObserver> trackers = new ArrayList<ComputerMetricsObserver>();
    private final HashMap<UUID, BasicComputerMetricsObserver> instances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicComputerMetricsObserver getMetricsInstance(UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            BasicComputerMetricsObserver context = this.instances.get(uuid);
            if (context == null) {
                context = new BasicComputerMetricsObserver(this);
                this.instances.put(uuid, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ComputerMetricsObserver tracker) {
        Object object = this.lock;
        synchronized (object) {
            if (this.trackers.contains(tracker)) {
                return;
            }
            this.trackers.add(tracker);
            this.enabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ComputerMetricsObserver tracker) {
        Object object = this.lock;
        synchronized (object) {
            this.trackers.remove(tracker);
            this.enabled = !this.trackers.isEmpty();
        }
    }

    public MetricsObserver createMetricObserver(ServerComputer computer) {
        return new DispatchObserver(computer);
    }

    private final class DispatchObserver
    implements MetricsObserver {
        private final ServerComputer computer;

        private DispatchObserver(ServerComputer computer) {
            this.computer = computer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observe(Metric.Counter counter) {
            if (!GlobalMetrics.this.enabled) {
                return;
            }
            Object object = GlobalMetrics.this.lock;
            synchronized (object) {
                for (ComputerMetricsObserver observer : GlobalMetrics.this.trackers) {
                    observer.observe(this.computer, counter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observe(Metric.Event event, long value) {
            if (!GlobalMetrics.this.enabled) {
                return;
            }
            Object object = GlobalMetrics.this.lock;
            synchronized (object) {
                for (ComputerMetricsObserver observer : GlobalMetrics.this.trackers) {
                    observer.observe(this.computer, event, value);
                }
            }
        }
    }
}

