/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.blocks.tileentity.TileEntityBlastFurnace;
import de.maxhenkel.car.blocks.tileentity.TileEntityCable;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.blocks.tileentity.TileEntityDynamo;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.blocks.tileentity.TileEntityOilMill;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSign;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSplitTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererTank;
import de.maxhenkel.car.blocks.tileentity.render.TileentitySpecialRendererGasStation;
import de.maxhenkel.car.commands.CommandCarDemo;
import de.maxhenkel.car.config.ClientConfig;
import de.maxhenkel.car.config.FuelConfig;
import de.maxhenkel.car.config.ServerConfig;
import de.maxhenkel.car.corelib.ClientRegistry;
import de.maxhenkel.car.corelib.CommonRegistry;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.config.DynamicConfig;
import de.maxhenkel.car.corelib.dataserializers.DataSerializerItemList;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.model.GenericCarModel;
import de.maxhenkel.car.events.BlockEvents;
import de.maxhenkel.car.events.CapabilityEvents;
import de.maxhenkel.car.events.KeyEvents;
import de.maxhenkel.car.events.PlayerEvents;
import de.maxhenkel.car.events.RenderEvents;
import de.maxhenkel.car.events.SoundEvents;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import de.maxhenkel.car.gui.ContainerBlastFurnace;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.gui.ContainerFactoryTileEntity;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.gui.ContainerGenerator;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.gui.ContainerOilMill;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.gui.ContainerSplitTank;
import de.maxhenkel.car.gui.GuiBackmixReactor;
import de.maxhenkel.car.gui.GuiBlastFurnace;
import de.maxhenkel.car.gui.GuiCar;
import de.maxhenkel.car.gui.GuiCarInventory;
import de.maxhenkel.car.gui.GuiCarWorkshopCrafting;
import de.maxhenkel.car.gui.GuiCarWorkshopRepair;
import de.maxhenkel.car.gui.GuiFluidExtractor;
import de.maxhenkel.car.gui.GuiGasStation;
import de.maxhenkel.car.gui.GuiGasStationAdmin;
import de.maxhenkel.car.gui.GuiGenerator;
import de.maxhenkel.car.gui.GuiLicensePlate;
import de.maxhenkel.car.gui.GuiOilMill;
import de.maxhenkel.car.gui.GuiPainter;
import de.maxhenkel.car.gui.GuiSign;
import de.maxhenkel.car.gui.GuiSplitTank;
import de.maxhenkel.car.integration.IMC;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.loottable.CopyFluid;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageCenterCarClient;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.net.MessageEditLicensePlate;
import de.maxhenkel.car.net.MessageEditSign;
import de.maxhenkel.car.net.MessageGasStationAdminAmount;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.net.MessageStarting;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import de.maxhenkel.car.recipes.BlastFurnaceRecipe;
import de.maxhenkel.car.recipes.KeyRecipe;
import de.maxhenkel.car.recipes.OilMillRecipe;
import de.maxhenkel.car.recipes.RecipeSerializerBlastFurnace;
import de.maxhenkel.car.recipes.RecipeSerializerOilMill;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.villagers.VillagerEvents;
import de.maxhenkel.tools.EntityTools;
import java.util.Collection;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="car")
public class Main {
    public static final String MODID = "car";
    public static final Logger LOGGER = LogManager.getLogger((String)"car");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType<EntityGenericCar> CAR_ENTITY_TYPE;
    public static LootItemFunctionType COPY_FLUID;
    public static PoiType POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT;
    public static VillagerProfession VILLAGER_PROFESSION_GAS_STATION_ATTENDANT;
    public static ServerConfig SERVER_CONFIG;
    public static FuelConfig FUEL_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static KeyMapping CAR_GUI_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping HORN_KEY;
    public static KeyMapping CENTER_KEY;
    public static MenuType<ContainerBackmixReactor> BACKMIX_REACTOR_CONTAINER_TYPE;
    public static MenuType<ContainerBlastFurnace> BLAST_FURNACE_CONTAINER_TYPE;
    public static MenuType<ContainerCar> CAR_CONTAINER_TYPE;
    public static MenuType<ContainerCarInventory> CAR_INVENTORY_CONTAINER_TYPE;
    public static MenuType<ContainerCarWorkshopCrafting> CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE;
    public static MenuType<ContainerCarWorkshopRepair> CAR_WORKSHOP_REPAIR_CONTAINER_TYPE;
    public static MenuType<ContainerFluidExtractor> FLUID_EXTRACTOR_CONTAINER_TYPE;
    public static MenuType<ContainerGasStation> GAS_STATION_CONTAINER_TYPE;
    public static MenuType<ContainerGasStationAdmin> GAS_STATION_ADMIN_CONTAINER_TYPE;
    public static MenuType<ContainerGenerator> GENERATOR_CONTAINER_TYPE;
    public static MenuType<ContainerLicensePlate> LICENSE_PLATE_CONTAINER_TYPE;
    public static MenuType<ContainerOilMill> OIL_MILL_CONTAINER_TYPE;
    public static MenuType<ContainerPainter> PAINTER_CONTAINER_TYPE;
    public static MenuType<ContainerSign> SIGN_CONTAINER_TYPE;
    public static MenuType<ContainerSplitTank> SPLIT_TANK_CONTAINER_TYPE;
    public static BlockEntityType<TileEntityGenerator> GENERATOR_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityBackmixReactor> BACKMIX_REACTOR_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityBlastFurnace> BLAST_FURNACE_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityCable> CABLE_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityCarWorkshop> CAR_WORKSHOP_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityDynamo> DYNAMO_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityFluidExtractor> FLUID_EXTRACTOR_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityOilMill> OIL_MILL_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntitySign> SIGN_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntitySplitTank> SPLIT_TANK_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityTank> TANK_TILE_ENTITY_TYPE;
    public static BlockEntityType<TileEntityGasStation> GAS_STATION_TILE_ENTITY_TYPE;
    public static RecipeSerializer<KeyRecipe> CRAFTING_SPECIAL_KEY;
    public static RecipeSerializer<BlastFurnaceRecipe> CRAFTING_BLAST_FURNACE;
    public static RecipeSerializer<OilMillRecipe> CRAFTING_OIL_MILL;
    public static RecipeType<BlastFurnaceRecipe> RECIPE_TYPE_BLAST_FURNACE;
    public static RecipeType<BlastFurnaceRecipe> RECIPE_TYPE_OIL_MILL;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(MenuType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(BlockEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(RecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(DataSerializerEntry.class, this::registerSerializers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Fluid.class, this::registerFluids);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(PoiType.class, this::registerPointsOfInterest);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(VillagerProfession.class, this::registerVillagerProfessions);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IMC::enqueueIMC);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        FUEL_CONFIG = CommonRegistry.registerDynamicConfig(DynamicConfig.DynamicConfigType.SERVER, MODID, "fuel", FuelConfig.class);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandCarDemo.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new VillagerEvents());
        COPY_FLUID = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation(MODID, "copy_fluid"), (Object)new LootItemFunctionType((Serializer)new CopyFluid.Serializer()));
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessageCarGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, MessageStarting.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, MessageCrash.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, MessageStartFuel.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 6, MessageSyncTileEntity.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 7, MessageSpawnCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 8, MessageOpenCarWorkshopGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 9, MessageRepairCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 10, MessageCarHorn.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 11, MessageEditSign.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 12, MessageGasStationAdminAmount.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 13, MessageCenterCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 14, MessageCenterCarClient.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 15, MessageEditLicensePlate.class);
        ComposterBlock.f_51914_.put((Object)ModItems.CANOLA_SEEDS, 0.3f);
        ComposterBlock.f_51914_.put((Object)ModItems.CANOLA_CAKE, 0.5f);
        ComposterBlock.f_51914_.put((Object)ModItems.CANOLA, 0.65f);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(GAS_STATION_TILE_ENTITY_TYPE, TileentitySpecialRendererGasStation::new);
        BlockEntityRenderers.m_173590_(SPLIT_TANK_TILE_ENTITY_TYPE, TileEntitySpecialRendererSplitTank::new);
        BlockEntityRenderers.m_173590_(TANK_TILE_ENTITY_TYPE, TileEntitySpecialRendererTank::new);
        BlockEntityRenderers.m_173590_(SIGN_TILE_ENTITY_TYPE, TileEntitySpecialRendererSign::new);
        ClientRegistry.registerScreen(BACKMIX_REACTOR_CONTAINER_TYPE, GuiBackmixReactor::new);
        ClientRegistry.registerScreen(BLAST_FURNACE_CONTAINER_TYPE, GuiBlastFurnace::new);
        ClientRegistry.registerScreen(CAR_CONTAINER_TYPE, GuiCar::new);
        ClientRegistry.registerScreen(CAR_INVENTORY_CONTAINER_TYPE, GuiCarInventory::new);
        ClientRegistry.registerScreen(CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE, GuiCarWorkshopCrafting::new);
        ClientRegistry.registerScreen(CAR_WORKSHOP_REPAIR_CONTAINER_TYPE, GuiCarWorkshopRepair::new);
        ClientRegistry.registerScreen(FLUID_EXTRACTOR_CONTAINER_TYPE, GuiFluidExtractor::new);
        ClientRegistry.registerScreen(GAS_STATION_CONTAINER_TYPE, GuiGasStation::new);
        ClientRegistry.registerScreen(GAS_STATION_ADMIN_CONTAINER_TYPE, GuiGasStationAdmin::new);
        ClientRegistry.registerScreen(GENERATOR_CONTAINER_TYPE, GuiGenerator::new);
        ClientRegistry.registerScreen(LICENSE_PLATE_CONTAINER_TYPE, GuiLicensePlate::new);
        ClientRegistry.registerScreen(OIL_MILL_CONTAINER_TYPE, GuiOilMill::new);
        ClientRegistry.registerScreen(PAINTER_CONTAINER_TYPE, GuiPainter::new);
        ClientRegistry.registerScreen(SIGN_CONTAINER_TYPE, GuiSign::new);
        ClientRegistry.registerScreen(SPLIT_TANK_CONTAINER_TYPE, GuiSplitTank::new);
        FORWARD_KEY = ClientRegistry.registerKeyBinding("key.car_forward", "category.car", 87);
        BACK_KEY = ClientRegistry.registerKeyBinding("key.car_back", "category.car", 83);
        LEFT_KEY = ClientRegistry.registerKeyBinding("key.car_left", "category.car", 65);
        RIGHT_KEY = ClientRegistry.registerKeyBinding("key.car_right", "category.car", 68);
        CAR_GUI_KEY = ClientRegistry.registerKeyBinding("key.car_gui", "category.car", 73);
        START_KEY = ClientRegistry.registerKeyBinding("key.car_start", "category.car", 82);
        HORN_KEY = ClientRegistry.registerKeyBinding("key.car_horn", "category.car", 72);
        CENTER_KEY = ClientRegistry.registerKeyBinding("key.center_car", "category.car", 32);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SoundEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        EntityRenderers.m_174036_(CAR_ENTITY_TYPE, GenericCarModel::new);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])((Item[])ModBlocks.getBlocksWithItems().stream().map(IItemBlock::toItem).toArray(Item[]::new)));
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.getAll().toArray(new Item[0]));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.getAll().toArray(new Block[0]));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.CANOLA_CROP, (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.SPLIT_TANK, (RenderType)RenderType.m_110463_());
            for (BlockPaint block : ModBlocks.PAINTS) {
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
            }
            for (BlockPaint block : ModBlocks.YELLOW_PAINTS) {
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
            }
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.getAll().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        CAR_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, MODID, MobCategory.MISC, EntityGenericCar.class, builder -> builder.setTrackingRange(128).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new EntityGenericCar((Level)world)));
        event.getRegistry().register(CAR_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        BACKMIX_REACTOR_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerBackmixReactor, TileEntityBackmixReactor>(ContainerBackmixReactor::new));
        BACKMIX_REACTOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "backmix_reactor"));
        event.getRegistry().register(BACKMIX_REACTOR_CONTAINER_TYPE);
        BLAST_FURNACE_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerBlastFurnace, TileEntityBlastFurnace>(ContainerBlastFurnace::new));
        BLAST_FURNACE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(BLAST_FURNACE_CONTAINER_TYPE);
        CAR_CONTAINER_TYPE = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.f_35978_, data.m_130259_());
            if (car == null) {
                return null;
            }
            return new ContainerCar(windowId, car, inv);
        }));
        CAR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(CAR_CONTAINER_TYPE);
        CAR_INVENTORY_CONTAINER_TYPE = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.f_35978_, data.m_130259_());
            if (car == null) {
                return null;
            }
            return new ContainerCarInventory(windowId, car, inv);
        }));
        CAR_INVENTORY_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_inventory"));
        event.getRegistry().register(CAR_INVENTORY_CONTAINER_TYPE);
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerCarWorkshopCrafting, TileEntityCarWorkshop>(ContainerCarWorkshopCrafting::new));
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop_crafting"));
        event.getRegistry().register(CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE);
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerCarWorkshopRepair, TileEntityCarWorkshop>(ContainerCarWorkshopRepair::new));
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop_repair"));
        event.getRegistry().register(CAR_WORKSHOP_REPAIR_CONTAINER_TYPE);
        FLUID_EXTRACTOR_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerFluidExtractor, TileEntityFluidExtractor>(ContainerFluidExtractor::new));
        FLUID_EXTRACTOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fluid_extractor"));
        event.getRegistry().register(FLUID_EXTRACTOR_CONTAINER_TYPE);
        GAS_STATION_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerGasStation, TileEntityGasStation>(ContainerGasStation::new));
        GAS_STATION_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station"));
        event.getRegistry().register(GAS_STATION_CONTAINER_TYPE);
        GAS_STATION_ADMIN_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerGasStationAdmin, TileEntityGasStation>(ContainerGasStationAdmin::new));
        GAS_STATION_ADMIN_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station_admin"));
        event.getRegistry().register(GAS_STATION_ADMIN_CONTAINER_TYPE);
        GENERATOR_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerGenerator, TileEntityGenerator>(ContainerGenerator::new));
        GENERATOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "generator"));
        event.getRegistry().register(GENERATOR_CONTAINER_TYPE);
        LICENSE_PLATE_CONTAINER_TYPE = new MenuType((id, inv) -> {
            ItemStack licensePlate = null;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = inv.f_35978_.m_21120_(hand);
                if (!(stack.m_41720_() instanceof ItemLicensePlate)) continue;
                licensePlate = stack;
                break;
            }
            if (licensePlate != null) {
                return new ContainerLicensePlate(id, licensePlate);
            }
            return null;
        });
        LICENSE_PLATE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "license_plate"));
        event.getRegistry().register(LICENSE_PLATE_CONTAINER_TYPE);
        OIL_MILL_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerOilMill, TileEntityOilMill>(ContainerOilMill::new));
        OIL_MILL_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(OIL_MILL_CONTAINER_TYPE);
        PAINTER_CONTAINER_TYPE = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> new ContainerPainter(windowId, inv, data.readBoolean())));
        PAINTER_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "painter"));
        event.getRegistry().register(PAINTER_CONTAINER_TYPE);
        SIGN_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerSign, TileEntitySign>(ContainerSign::new));
        SIGN_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "sign"));
        event.getRegistry().register(SIGN_CONTAINER_TYPE);
        SPLIT_TANK_CONTAINER_TYPE = new MenuType(new ContainerFactoryTileEntity<ContainerSplitTank, TileEntitySplitTank>(ContainerSplitTank::new));
        SPLIT_TANK_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "split_tank"));
        event.getRegistry().register(SPLIT_TANK_CONTAINER_TYPE);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        GENERATOR_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityGenerator::new, (Block[])new Block[]{ModBlocks.GENERATOR}).m_58966_(null);
        GENERATOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "generator"));
        event.getRegistry().register(GENERATOR_TILE_ENTITY_TYPE);
        BACKMIX_REACTOR_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityBackmixReactor::new, (Block[])new Block[]{ModBlocks.BACKMIX_REACTOR}).m_58966_(null);
        BACKMIX_REACTOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "backmix_reactor"));
        event.getRegistry().register(BACKMIX_REACTOR_TILE_ENTITY_TYPE);
        BLAST_FURNACE_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityBlastFurnace::new, (Block[])new Block[]{ModBlocks.BLAST_FURNACE}).m_58966_(null);
        BLAST_FURNACE_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(BLAST_FURNACE_TILE_ENTITY_TYPE);
        CABLE_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityCable::new, (Block[])new Block[]{ModBlocks.CABLE}).m_58966_(null);
        CABLE_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "cable"));
        event.getRegistry().register(CABLE_TILE_ENTITY_TYPE);
        CAR_WORKSHOP_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityCarWorkshop::new, (Block[])new Block[]{ModBlocks.CAR_WORKSHOP}).m_58966_(null);
        CAR_WORKSHOP_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop"));
        event.getRegistry().register(CAR_WORKSHOP_TILE_ENTITY_TYPE);
        DYNAMO_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityDynamo::new, (Block[])new Block[]{ModBlocks.DYNAMO}).m_58966_(null);
        DYNAMO_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "dynamo"));
        event.getRegistry().register(DYNAMO_TILE_ENTITY_TYPE);
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityFluidExtractor::new, (Block[])new Block[]{ModBlocks.FLUID_EXTRACTOR}).m_58966_(null);
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "fluid_extractor"));
        event.getRegistry().register(FLUID_EXTRACTOR_TILE_ENTITY_TYPE);
        OIL_MILL_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityOilMill::new, (Block[])new Block[]{ModBlocks.OIL_MILL}).m_58966_(null);
        OIL_MILL_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(OIL_MILL_TILE_ENTITY_TYPE);
        SIGN_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntitySign::new, (Block[])new Block[]{ModBlocks.SIGN}).m_58966_(null);
        SIGN_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "sign"));
        event.getRegistry().register(SIGN_TILE_ENTITY_TYPE);
        SPLIT_TANK_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntitySplitTank::new, (Block[])new Block[]{ModBlocks.SPLIT_TANK}).m_58966_(null);
        SPLIT_TANK_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "split_tank"));
        event.getRegistry().register(SPLIT_TANK_TILE_ENTITY_TYPE);
        TANK_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityTank::new, (Block[])new Block[]{ModBlocks.TANK}).m_58966_(null);
        TANK_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "tank"));
        event.getRegistry().register(TANK_TILE_ENTITY_TYPE);
        GAS_STATION_TILE_ENTITY_TYPE = BlockEntityType.Builder.m_155273_(TileEntityGasStation::new, (Block[])new Block[]{ModBlocks.GAS_STATION}).m_58966_(null);
        GAS_STATION_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "gas_station"));
        event.getRegistry().register(GAS_STATION_TILE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        CRAFTING_SPECIAL_KEY = new SimpleRecipeSerializer(KeyRecipe::new);
        CRAFTING_SPECIAL_KEY.setRegistryName(new ResourceLocation(MODID, "crafting_special_key"));
        event.getRegistry().register(CRAFTING_SPECIAL_KEY);
        CRAFTING_BLAST_FURNACE = new RecipeSerializerBlastFurnace(BlastFurnaceRecipe::new);
        CRAFTING_BLAST_FURNACE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(CRAFTING_BLAST_FURNACE);
        CRAFTING_OIL_MILL = new RecipeSerializerOilMill(OilMillRecipe::new);
        CRAFTING_OIL_MILL.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(CRAFTING_OIL_MILL);
        RECIPE_TYPE_BLAST_FURNACE = (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(MODID, "blast_furnace"), (Object)new RecipeType<BlastFurnaceRecipe>(){

            public String toString() {
                return "blast_furnace";
            }
        });
        RECIPE_TYPE_OIL_MILL = (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(MODID, "oil_mill"), (Object)new RecipeType<BlastFurnaceRecipe>(){

            public String toString() {
                return "oil_mill";
            }
        });
    }

    @SubscribeEvent
    public void registerSerializers(RegistryEvent.Register<DataSerializerEntry> event) {
        DataSerializerItemList.register(event, new ResourceLocation(MODID, "serializer_item_list"));
    }

    @SubscribeEvent
    public void registerFluids(RegistryEvent.Register<Fluid> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Fluid[]{ModFluids.CANOLA_OIL, ModFluids.CANOLA_OIL_FLOWING, ModFluids.METHANOL, ModFluids.METHANOL_FLOWING, ModFluids.CANOLA_METHANOL_MIX, ModFluids.CANOLA_METHANOL_MIX_FLOWING, ModFluids.GLYCERIN, ModFluids.GLYCERIN_FLOWING, ModFluids.BIO_DIESEL, ModFluids.BIO_DIESEL_FLOWING});
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.CANOLA_OIL, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.CANOLA_OIL_FLOWING, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.METHANOL, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.METHANOL_FLOWING, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.CANOLA_METHANOL_MIX, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.CANOLA_METHANOL_MIX_FLOWING, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.GLYCERIN, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.GLYCERIN_FLOWING, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.BIO_DIESEL, (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)ModFluids.BIO_DIESEL_FLOWING, (RenderType)RenderType.m_110466_());
        }
    }

    @SubscribeEvent
    public void registerPointsOfInterest(RegistryEvent.Register<PoiType> event) {
        POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT = new PoiType("gas_station_attendant", (Set)ImmutableSet.copyOf((Collection)ModBlocks.GAS_STATION.m_49965_().m_61056_()), 1, 1);
        POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT.setRegistryName(MODID, "gas_station_attendant");
        event.getRegistry().register((IForgeRegistryEntry)POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT);
    }

    @SubscribeEvent
    public void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        VILLAGER_PROFESSION_GAS_STATION_ATTENDANT = new VillagerProfession("gas_station_attendant", POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT, ImmutableSet.of(), ImmutableSet.of(), ModSounds.GAS_STATION_ATTENDANT);
        VILLAGER_PROFESSION_GAS_STATION_ATTENDANT.setRegistryName(MODID, "gas_station_attendant");
        event.getRegistry().register((IForgeRegistryEntry)VILLAGER_PROFESSION_GAS_STATION_ATTENDANT);
        VillagerProfession.f_35590_.f_35602_ = ImmutableSet.builder().addAll((Iterable)VillagerProfession.f_35590_.m_35623_()).add((Object)ModItems.CANOLA_SEEDS).add((Object)ModItems.CANOLA).build();
        Villager.f_35372_ = ImmutableSet.builder().addAll((Iterable)Villager.f_35372_).add((Object)ModItems.CANOLA_SEEDS).add((Object)ModItems.CANOLA).build();
    }
}

