/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.corelib.dataserializers;

import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DataSerializerItemList {
    public static final EntityDataSerializer<NonNullList<ItemStack>> ITEM_LIST = new EntityDataSerializer<NonNullList<ItemStack>>(){

        public void write(FriendlyByteBuf packetBuffer, NonNullList<ItemStack> itemStacks) {
            packetBuffer.writeInt(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                packetBuffer.m_130055_(itemStack);
            }
        }

        public NonNullList<ItemStack> read(FriendlyByteBuf buf) {
            int length = buf.readInt();
            NonNullList list = NonNullList.m_122780_((int)length, (Object)ItemStack.f_41583_);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)buf.m_130267_());
            }
            return list;
        }

        public EntityDataAccessor<NonNullList<ItemStack>> createKey(int id) {
            return new EntityDataAccessor(id, (EntityDataSerializer)this);
        }

        public NonNullList<ItemStack> copy(NonNullList<ItemStack> itemStacks) {
            NonNullList list = NonNullList.m_122780_((int)itemStacks.size(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < itemStacks.size(); ++i) {
                list.set(i, (Object)((ItemStack)itemStacks.get(i)).m_41777_());
            }
            return list;
        }
    };

    public static void register(RegistryEvent.Register<DataSerializerEntry> event, ResourceLocation registryName) {
        DataSerializerEntry dataSerializerEntryItemList = new DataSerializerEntry(ITEM_LIST);
        dataSerializerEntryItemList.setRegistryName(registryName);
        event.getRegistry().register((IForgeRegistryEntry)dataSerializerEntryItemList);
    }
}

