/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.DoubleDoorMessage;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class DoubleDoorOpeningModule
extends QuarkModule {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!event.getWorld().f_46443_ || event.getPlayer().m_20163_() || event.isCanceled() || event.getResult() == Event.Result.DENY || event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        Level world = event.getWorld();
        if (world.m_8055_(pos = event.getPos()).m_60734_() instanceof DoorBlock) {
            DoubleDoorOpeningModule.openDoor(world, event.getPlayer(), pos);
            QuarkNetwork.sendToServer(new DoubleDoorMessage(pos));
        }
    }

    public static void openDoor(Level world, Player player, BlockPos pos) {
        BlockHitResult res;
        if (!ModuleLoader.INSTANCE.isModuleEnabled(DoubleDoorOpeningModule.class) || world == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        Direction direction = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
        boolean isOpen = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
        DoorHingeSide isMirrored = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
        BlockPos mirrorPos = pos.m_142300_(isMirrored == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_());
        BlockPos doorPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.m_7495_();
        BlockState other = world.m_8055_(doorPos);
        if (state.m_60767_() != Material.f_76279_ && other.m_60734_() == state.m_60734_() && other.m_61143_((Property)DoorBlock.f_52726_) == direction && (Boolean)other.m_61143_((Property)DoorBlock.f_52727_) == isOpen && other.m_61143_((Property)DoorBlock.f_52728_) != isMirrored && (res = new BlockHitResult(new Vec3((double)doorPos.m_123341_() + 0.5, (double)doorPos.m_123342_() + 0.5, (double)doorPos.m_123343_() + 0.5), direction, doorPos, false)).m_6662_() == HitResult.Type.BLOCK) {
            other.m_60664_(world, player, InteractionHand.MAIN_HAND, res);
        }
    }
}

