/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize((String)tag, (String)".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith("pattern:")) {
            this.type = 1;
            value = value.substring("pattern:".length());
        } else if (value.startsWith("ipattern:")) {
            this.type = 2;
            value = value.substring("ipattern:".length()).toLowerCase();
        } else if (value.startsWith("regex:")) {
            this.type = 3;
            value = value.substring("regex:".length());
        } else if (value.startsWith("iregex:")) {
            this.type = 4;
            value = value.substring("iregex:".length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(ok nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(ok nbt) {
        if (nbt == null) {
            return false;
        }
        ok tagBase = nbt;
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String tag = this.parents[i2];
            if ((tagBase = NbtTagValue.getChildTag((pd)tagBase, (String)tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((pd)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((pd)tagBase, (String)this.name)) == null) {
            return false;
        }
        return this.matchesBase((pd)tagBase);
    }

    private boolean matchesAnyChild(pd tagBase) {
        if (tagBase instanceof ok) {
            ok tagCompound = (ok)tagBase;
            Set nbtKeySet = tagCompound.d();
            for (String key : nbtKeySet) {
                pd nbtBase = tagCompound.c(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof oq) {
            oq tagList = (oq)tagBase;
            int count = tagList.size();
            for (int i2 = 0; i2 < count; ++i2) {
                pd nbtBase = tagList.k(i2);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static pd getChildTag(pd tagBase, String tag) {
        if (tagBase instanceof ok) {
            ok tagCompound = (ok)tagBase;
            return tagCompound.c(tag);
        }
        if (tagBase instanceof oq) {
            oq tagList = (oq)tagBase;
            if (tag.equals("count")) {
                return op.a((int)tagList.size());
            }
            int index = Config.parseInt((String)tag, (int)-1);
            if (index < 0 || index >= tagList.size()) {
                return null;
            }
            return tagList.k(index);
        }
        return null;
    }

    public boolean matchesBase(pd nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getNbtString((pd)nbtBase, (int)this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask((String)str, (String)pattern, (char)'*', (char)'?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(pd nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof pb) {
            pb nbtString = (pb)nbtBase;
            String text = nbtString.e_();
            if (text.startsWith("{") && text.endsWith("}")) {
                text = NbtTagValue.getMergedJsonText((String)text);
            } else if (text.startsWith("[{") && text.endsWith("}]")) {
                text = NbtTagValue.getMergedJsonText((String)text);
            }
            return text;
        }
        if (nbtBase instanceof op) {
            op i2 = (op)nbtBase;
            if (format == 1) {
                return "#" + StrUtils.fillLeft((String)Integer.toHexString(i2.f()), (int)6, (char)'0');
            }
            return Integer.toString(i2.f());
        }
        if (nbtBase instanceof oi) {
            oi b2 = (oi)nbtBase;
            return Byte.toString(b2.h());
        }
        if (nbtBase instanceof oy) {
            oy s = (oy)nbtBase;
            return Short.toString(s.g());
        }
        if (nbtBase instanceof os) {
            os l = (os)nbtBase;
            return Long.toString(l.e());
        }
        if (nbtBase instanceof on) {
            on f = (on)nbtBase;
            return Float.toString(f.j());
        }
        if (nbtBase instanceof ol) {
            ol d2 = (ol)nbtBase;
            return Double.toString(d2.i());
        }
        return nbtBase.toString();
    }

    private static String getMergedJsonText(String text) {
        StringBuilder sb = new StringBuilder();
        String TOKEN_TEXT = "\"text\":\"";
        int pos = -1;
        while ((pos = text.indexOf(TOKEN_TEXT, pos + 1)) >= 0) {
            String str = NbtTagValue.parseString((String)text, (int)(pos + TOKEN_TEXT.length()));
            if (str == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static String parseString(String text, int pos) {
        StringBuilder sb = new StringBuilder();
        boolean escapeMode = false;
        for (int i2 = pos; i2 < text.length(); ++i2) {
            char ch = text.charAt(i2);
            if (escapeMode) {
                if (ch == 'b') {
                    sb.append('\b');
                } else if (ch == 'f') {
                    sb.append('\f');
                } else if (ch == 'n') {
                    sb.append('\n');
                } else if (ch == 'r') {
                    sb.append('\r');
                } else if (ch == 't') {
                    sb.append('\t');
                } else {
                    sb.append(ch);
                }
                escapeMode = false;
                continue;
            }
            if (ch == '\\') {
                escapeMode = true;
                continue;
            }
            if (ch == '\"') break;
            sb.append(ch);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String parent = this.parents[i2];
            if (i2 > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

