/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.entity.interfaces;

import dev.itsmeow.betteranimalmodels.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.variant.IVariant;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public interface ISelectiveVariantTypes<T extends Mob>
extends IVariantTypes<T> {
    @Override
    @Nullable
    default public SpawnGroupData initData(LevelAccessor world, MobSpawnType reason, SpawnGroupData livingdata) {
        return this.useSelectiveTypes(reason) ? this.dataFromVariant(this.getRandomVariantForBiome(world, reason), livingdata) : IVariantTypes.super.initData(world, reason, livingdata);
    }

    @Override
    @Nullable
    default public SpawnGroupData initAgeableData(LevelAccessor world, MobSpawnType reason, SpawnGroupData livingdata) {
        return this.useSelectiveTypes(reason) ? this.ageableDataFromVariant(this.getRandomVariantForBiome(world, reason), livingdata) : IVariantTypes.super.initAgeableData(world, reason, livingdata);
    }

    public String[] getTypesFor(ResourceKey<Biome> var1, Biome var2, Set<BiomeTypes.Type> var3, MobSpawnType var4);

    default public boolean useSelectiveTypes() {
        return this.getContainer().getConfiguration().biomeVariants.get();
    }

    default public boolean useSelectiveTypes(MobSpawnType reason) {
        return this.useSelectiveTypes() && (reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.NATURAL);
    }

    @Nullable
    default public IVariant getRandomVariantForBiome(LevelAccessor world, MobSpawnType reason) {
        Holder biome = world.m_204166_(this.getImplementation().m_142538_());
        Optional biomeKey = biome.m_203543_();
        biomeKey.orElseThrow(() -> new RuntimeException("Biome provided to selective type generation has no ID found."));
        String[] validTypes = this.getTypesFor((ResourceKey<Biome>)((ResourceKey)biomeKey.get()), (Biome)biome.m_203334_(), BiomeTypes.getTypes((ResourceKey<Biome>)((ResourceKey)biomeKey.get())), reason);
        String varStr = validTypes[this.getImplementation().m_21187_().nextInt(validTypes.length)];
        Optional<IVariant> variant = this.getContainer().getVariantForName(varStr);
        if (!variant.isPresent() || !varStr.equals(variant.get().getName())) {
            throw new RuntimeException("Received invalid variant \"" + varStr + "\" from selective type on entity " + this.getContainer().getEntityName());
        }
        return variant.get();
    }
}

