/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import java.util.List;
import java.util.Stack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();
    public static final BaseScreen BLANK_GUI = new BaseScreen(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };

    public static void setupDrawing() {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
    }

    public static void playSound(SoundEvent event, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)pitch));
    }

    public static void drawTexturedRect(PoseStack matrixStack, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        RenderSystem.m_69493_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        GuiHelper.addRectToBufferWithUV(matrixStack, buffer, x, y, w, h, col, u0, v0, u1, v1);
        tesselator.m_85914_();
    }

    public static void addRectToBuffer(PoseStack matrixStack, BufferBuilder buffer, int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Matrix4f m = matrixStack.m_85850_().m_85861_();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
    }

    public static void addRectToBufferWithUV(PoseStack matrixStack, BufferBuilder buffer, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Matrix4f m = matrixStack.m_85850_().m_85861_();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_(u0, v1).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v1).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v0).m_5752_();
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(u0, v0).m_5752_();
    }

    public static void drawHollowRect(PoseStack matrixStack, int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(matrixStack, x, y, w, h);
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69472_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, w, 1, col);
        }
        tesselator.m_85914_();
        RenderSystem.m_69493_();
    }

    public static void drawRectWithShade(PoseStack matrixStack, int x, int y, int w, int h, Color4I col, int intensity) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69472_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 1, 1, col);
        tesselator.m_85914_();
        RenderSystem.m_69493_();
    }

    public static void drawItem(PoseStack poseStack, ItemStack stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        BakedModel bakedModel = itemRenderer.m_174264_(stack, null, (LivingEntity)mc.f_91074_, hash);
        Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flatLight = !bakedModel.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (flatLight) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        if (renderOverlay) {
            float cooldown;
            Tesselator t = Tesselator.m_85913_();
            Font font = mc.f_91062_;
            if (stack.m_41613_() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                poseStack.m_85836_();
                poseStack.m_85837_(9.0 - (double)font.m_92895_(s), 1.0, 20.0);
                font.m_92811_(s, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                bufferSource.m_109911_();
                poseStack.m_85849_();
            }
            if (stack.m_150947_()) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69461_();
                int barWidth = stack.m_150948_();
                int barColor = stack.m_150949_();
                GuiHelper.draw(poseStack, t, -6, 5, 13, 2, 0, 0, 0, 255);
                GuiHelper.draw(poseStack, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
            float f = cooldown = mc.f_91074_ == null ? 0.0f : mc.f_91074_.m_36335_().m_41521_(stack.m_41720_(), mc.m_91296_());
            if (cooldown > 0.0f) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                GuiHelper.draw(poseStack, t, -8, Mth.m_14143_((float)(16.0f * (1.0f - cooldown))) - 8, 16, Mth.m_14167_((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
        }
    }

    private static void draw(PoseStack matrixStack, Tesselator t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f m = matrixStack.m_85850_().m_85861_();
        BufferBuilder renderer = t.m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(m, (float)x, (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(m, (float)(x + width), (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(m, (float)(x + width), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        t.m_85914_();
    }

    public static void pushScissor(Window screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(Window screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static String clickEventToString(@Nullable ClickEvent event) {
        if (event == null) {
            return "";
        }
        return switch (event.m_130622_()) {
            case ClickEvent.Action.OPEN_URL, ClickEvent.Action.CHANGE_PAGE -> event.m_130623_();
            case ClickEvent.Action.OPEN_FILE -> "file:" + event.m_130623_();
            case ClickEvent.Action.RUN_COMMAND -> "command:" + event.m_130623_();
            case ClickEvent.Action.SUGGEST_COMMAND -> "suggest_command:" + event.m_130623_();
            default -> "";
        };
    }

    public static void addStackTooltip(ItemStack stack, List<Component> list) {
        GuiHelper.addStackTooltip(stack, list, null);
    }

    public static void addStackTooltip(ItemStack stack, List<Component> list, @Nullable Component prefix) {
        List tooltip = stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        list.add((Component)(prefix == null ? ((Component)tooltip.get(0)).m_6881_().m_130940_(stack.m_41791_().f_43022_) : prefix.m_6881_().m_7220_((Component)tooltip.get(0))));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add((Component)new TextComponent("").m_130940_(ChatFormatting.GRAY).m_7220_((Component)tooltip.get(i)));
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(Window screen) {
            double scale = screen.m_85449_();
            int sx = (int)((double)this.x * scale);
            int sy = (int)((double)(screen.m_85446_() - (this.y + this.h)) * scale);
            int sw = (int)((double)this.w * scale);
            int sh = (int)((double)this.h * scale);
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

