/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DelayedTileEmission
extends AbstractEntityEmission<BlockEntity, Emitter> {
    protected final Map<Pollutant<?>, Integer> amounts = new HashMap();
    protected int fails = 0;
    protected int emits = 0;

    protected DelayedTileEmission(BlockEntity tile, Emitter emitter, GameTime updateInterval) {
        super(tile, emitter, updateInterval);
    }

    public static DelayedTileEmission of(BlockEntity tile, Emitter emitter, Pollutant<?> pollutant, int amount) {
        return new DelayedTileEmission(tile, emitter, GameTime.seconds((int)3)).add(pollutant, amount);
    }

    public DelayedTileEmission add(Pollutant<?> pollutant, int amount) {
        int old = this.getAmountOf(pollutant);
        this.amounts.put(pollutant, old + amount);
        this.checkAmountOf(pollutant);
        return this;
    }

    protected void checkAmountOf(Pollutant<?> pollutant) {
        if (this.getAmountOf(pollutant) <= 0) {
            this.amounts.remove(pollutant);
        }
    }

    public int getAmountOf(Pollutant<?> pollutant) {
        Integer amount = this.amounts.get(pollutant);
        return amount != null ? amount : 0;
    }

    public int getPollutantsNumber() {
        return this.amounts.keySet().size();
    }

    @Nullable
    public Pollutant<?> pickPollutant() {
        int chosen = CommonMath.Random.between((int)0, (int)(this.getPollutantsNumber() - 1));
        int i = 0;
        for (Pollutant<?> pollutant : this.amounts.keySet()) {
            if (i < chosen) {
                ++i;
                continue;
            }
            if (i != chosen) break;
            return pollutant;
        }
        return null;
    }

    @Nullable
    public Level getWorldLevel() {
        return ((BlockEntity)this.getEntity()).m_58904_();
    }

    @Override
    public BlockPos getEntityBlockPos() {
        return ((BlockEntity)this.getEntity()).m_58899_();
    }

    public void onUpdate() {
        BlockPos pos;
        if (this.getPollutantsNumber() <= 0) {
            this.kill();
            return;
        }
        if (this.fails < 0) {
            this.fails = 0;
        }
        Level world = this.getWorldLevel();
        Pollutant<?> pollutant = this.pickPollutant();
        if (world == null || pollutant == null) {
            this.kill();
            return;
        }
        this.checkAmountOf(pollutant);
        int maxPressure = pollutant.getPollutionCapacity();
        int amount = Math.min(this.getAmountOf(pollutant), maxPressure);
        if (amount <= 0) {
            this.kill();
            return;
        }
        if (!this.isInEntityTickingChunk()) {
            return;
        }
        BlockEntity tile = (BlockEntity)this.getEntity();
        if (!tile.equals(world.m_7702_(pos = this.getEntityBlockPos()))) {
            this.kill();
            return;
        }
        if (this.fails > maxPressure) {
            if (GasExplosion.emitters) {
                pollutant.explodeBlock(world, pos, amount);
            }
            this.kill();
            return;
        }
        int count = pollutant.emitFrom(tile, ((Emitter)((Object)this.getEmitter())).getRelatedBlocks(), amount);
        if (count > 0) {
            this.add(pollutant, -count);
            this.fails = 0;
        } else {
            ++this.fails;
        }
    }
}

