/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.ForgeBucketItem;
import com.endertech.minecraft.forge.units.RegistryEntriesInit;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.items.GasBlockItem;
import com.endertech.minecraft.mods.adpother.items.Respirator;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegistryEvent;

public class Items
extends RegistryEntriesInit<Item> {
    public final Supplier<Aerometer> aerometer = this.addNew(() -> new Aerometer(this.getMod(), this.createConfigFor(Aerometer.class)));
    public final Supplier<ForgeBucketItem> pollutedWaterBucket;

    public Items(AbstractForgeMod mod) {
        super(mod, Item.class);
        UnitConfig bagConfig = this.createConfigFor(VacuumBag.class);
        UnitConfig tubeConfig = this.createConfigFor(VacuumTube.class);
        UnitConfig respiratorConfig = this.createConfigFor(Respirator.class);
        for (Materials material : Materials.values()) {
            material.vacuumBag = this.addNew(() -> new VacuumBag(this.getMod(), bagConfig, material));
            material.vacuumTube = this.addNew(() -> new VacuumTube(this.getMod(), tubeConfig, material));
            material.respirator = this.addNew(() -> new Respirator(this.getMod(), respiratorConfig, material));
            material.filterFrameItem = this.addNew(() -> new FilterFrame.BlockItem(material.filterFrame.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
        }
        this.pollutedWaterBucket = this.addNew(() -> new ForgeBucketItem("polluted_water_bucket", () -> (Fluid)AdPother.getInstance().fluids.pollutedWaterStill.get()));
    }

    protected void registerEntries(RegistryEvent.Register<Item> event) {
        AdPother.getInstance().pollutants.streamAll().filter(AbstractGas.class::isInstance).map(AbstractGas.class::cast).forEach(gas -> this.addNew(() -> new GasBlockItem((AbstractGas)((Object)gas), new Item.Properties().m_41486_().setNoRepair().m_41491_(CreativeModeTab.f_40759_))));
        super.registerEntries(event);
    }
}

