/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.ChestWearItem;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VacuumBag
extends ChestWearItem
implements IStorageItem {
    private final int capacity;

    public VacuumBag(AbstractForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.getName() + "_vacuum_bag", new Item.Properties().m_41491_(CreativeModeTab.f_40756_), 64, UnitId.from((String)"#forge:leather"), SoundEvents.f_11678_);
        this.capacity = UnitConfig.getInt((UnitConfig)config, (String)this.getUnitCategory(), (String)"capacity", (int)material.capacity, (IntBounds)IntBounds.INTEGER_POSITIVE, (String)"Defines the maximum capacity of the bag.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag flag) {
        IStorageItem.super.appendHoverText(stack, world, lines, flag);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        GasEntity carrier;
        Optional state;
        Level world = entity.f_19853_;
        if (this.isServerSide((LevelReader)world) && entity instanceof GasEntity && (state = (carrier = (GasEntity)entity).getCarriedBlockState()).isPresent() && carrier.spend()) {
            Block.m_49950_((BlockState)((BlockState)state.get()), (Level)world, (BlockPos)carrier.m_142538_());
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_60734_() instanceof Pollutant;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        this.installFiltersFor(stack, new Pollutant[]{Pollutants.BuiltIn.SULFUR.get()});
    }

    @Override
    public int fill(ItemStack storage, Pollutant<?> pollutant, int amount) {
        if (VacuumBag.isBroken((ItemStack)storage)) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        float gradeFactor = content.getFullnessPercentageFor(pollutant).getGrade().ordinal() + 1;
        float wearoutChance = 0.05f * gradeFactor;
        if (CommonMath.Random.result((float)wearoutChance)) {
            ForgeItem.damageItem((int)1, (ItemStack)storage, (boolean)false, null, null);
        }
        Percentage wearout = this.getWearoutPercentage(storage);
        boolean leak = false;
        if (wearout.getGrade() == Percentage.Grade.HIGH) {
            float chance = Percentage.HUNDRED.getValue() - wearout.getGrade().threshold;
            float probability = 1.0f / Math.max(1.0f, chance);
            leak = CommonMath.Random.result((float)probability);
        }
        if (leak) {
            return 0;
        }
        return IStorageItem.super.fill(storage, pollutant, amount);
    }

    @Override
    public int getInitialCapacity(ItemStack storage) {
        return this.capacity;
    }
}

