/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class Smog {
    public static boolean renderSmog = true;
    public static boolean colorSmog = true;
    private static final CommonTime.Interval updateInterval = GameTime.quaterSecond().getInterval();
    private static CommonTime.Stamp lastUpdate = CommonTime.Stamp.now();
    private static ColorARGB currentColor = ColorARGB.DEFAULT;
    private static ColorARGB pollutionColor = ColorARGB.DEFAULT;
    private static float currentDensity = 0.0f;
    private static float targetDensity = 0.0f;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (!renderSmog) {
            return;
        }
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)lastUpdate).moreThan(updateInterval)) {
            Entity entity = event.getCamera().m_90592_();
            EntityPollution pollution = WorldData.getEntityPollution(entity);
            targetDensity = (float)pollution.getPollutants().map(pollution::getInfluenceOf).mapToDouble(Percentage::toFraction).sum();
            pollutionColor = ColorARGB.blend(pollution.getPollutants().collect(Collectors.toMap(Pollutant::getColor, p -> (int)pollution.getInfluenceOf((Pollutant<?>)((Object)p)).getValue())));
            lastUpdate = CommonTime.Stamp.now();
        }
        float changingStep = 3.0E-4f;
        float delta = targetDensity - currentDensity;
        currentDensity = Math.abs(delta) >= Math.abs(changingStep) ? (currentDensity += changingStep * Math.signum(delta)) : targetDensity;
        if (Smog.updateFogDistance(-8.0f, 1.0f, () -> ((EntityViewRenderEvent.RenderFogEvent)event).getNearPlaneDistance(), arg_0 -> ((EntityViewRenderEvent.RenderFogEvent)event).setNearPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
        if (Smog.updateFogDistance(8.0f, 1.0f, () -> ((EntityViewRenderEvent.RenderFogEvent)event).getFarPlaneDistance(), arg_0 -> ((EntityViewRenderEvent.RenderFogEvent)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFogColors(EntityViewRenderEvent.FogColors event) {
        ColorARGB targetColor;
        if (!renderSmog || !colorSmog) {
            return;
        }
        FloatBounds range = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f));
        ColorARGB vanillaColor = ColorARGB.from((Color)new Color(range.enclose(Float.valueOf(event.getRed())).floatValue(), range.enclose(Float.valueOf(event.getGreen())).floatValue(), range.enclose(Float.valueOf(event.getBlue())).floatValue()));
        ColorARGB colorARGB = targetColor = pollutionColor.equals((Object)ColorARGB.DEFAULT) ? vanillaColor : vanillaColor.approxTo(pollutionColor, currentDensity);
        if (!currentColor.equals((Object)targetColor)) {
            currentColor = currentColor.approxTo(targetColor, 0.05f);
        }
        event.setRed(currentColor.getRed().toFloat());
        event.setGreen(currentColor.getGreen().toFloat());
        event.setBlue(currentColor.getBlue().toFloat());
    }

    private static boolean updateFogDistance(float min, float pow, Supplier<Float> getter, Consumer<Float> setter) {
        float factor;
        float current = getter.get().floatValue();
        FloatBounds bounds = FloatBounds.between((Float)Float.valueOf(min), (Float)Float.valueOf(current));
        float target = bounds.interpolateDown(factor = (float)Math.pow(currentDensity, pow)).floatValue();
        if (target < current) {
            setter.accept(Float.valueOf(target));
            return true;
        }
        return false;
    }
}

