/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingInventory;
import com.simibubi.create.content.logistics.block.inventories.BottomlessItemHandler;
import com.simibubi.create.content.logistics.block.vault.ItemVaultTileEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MountedStorage {
    private static final ItemStackHandler dummyHandler = new ItemStackHandler();
    ItemStackHandler handler;
    boolean noFuel;
    boolean valid;
    private BlockEntity te;

    public static boolean canUseAsStorage(BlockEntity te) {
        if (te == null) {
            return false;
        }
        if (te instanceof MechanicalCrafterTileEntity) {
            return false;
        }
        if (AllTileEntities.CREATIVE_CRATE.is(te)) {
            return true;
        }
        if (te instanceof ShulkerBoxBlockEntity) {
            return true;
        }
        if (te instanceof ChestBlockEntity) {
            return true;
        }
        if (te instanceof BarrelBlockEntity) {
            return true;
        }
        if (te instanceof ItemVaultTileEntity) {
            return true;
        }
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        IItemHandler handler = (IItemHandler)capability.orElse(null);
        return handler instanceof ItemStackHandler && !(handler instanceof ProcessingInventory);
    }

    public MountedStorage(BlockEntity te) {
        this.te = te;
        this.handler = dummyHandler;
        this.noFuel = te instanceof ItemVaultTileEntity;
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.te == null) {
            return;
        }
        if (this.te instanceof ChestBlockEntity) {
            CompoundTag tag = this.te.m_187480_();
            if (tag.m_128425_("LootTable", 8)) {
                return;
            }
            this.handler = new ItemStackHandler(((ChestBlockEntity)this.te).m_6643_());
            NonNullList items = NonNullList.m_122780_((int)this.handler.getSlots(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
            for (int i = 0; i < items.size(); ++i) {
                this.handler.setStackInSlot(i, (ItemStack)items.get(i));
            }
            this.valid = true;
            return;
        }
        IItemHandler teHandler = (IItemHandler)this.te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)dummyHandler);
        if (teHandler == dummyHandler) {
            return;
        }
        if (this.te instanceof ItemVaultTileEntity) {
            this.handler = ((ItemVaultTileEntity)this.te).getInventoryOfBlock();
            this.valid = true;
            return;
        }
        if (teHandler instanceof ItemStackHandler) {
            this.handler = (ItemStackHandler)teHandler;
            this.valid = true;
            return;
        }
        if (teHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)teHandler;
            this.handler = new ItemStackHandler(teHandler.getSlots());
            for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
                this.handler.setStackInSlot(slot, inv.getStackInSlot(slot));
                inv.setStackInSlot(slot, ItemStack.f_41583_);
            }
            this.valid = true;
            return;
        }
    }

    public void addStorageToWorld(BlockEntity te) {
        if (this.handler instanceof BottomlessItemHandler) {
            return;
        }
        if (te instanceof ChestBlockEntity) {
            CompoundTag tag = te.m_187480_();
            tag.m_128473_("Items");
            NonNullList items = NonNullList.m_122780_((int)this.handler.getSlots(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < items.size(); ++i) {
                items.set(i, (Object)this.handler.getStackInSlot(i));
            }
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)items);
            te.m_142466_(tag);
            return;
        }
        if (te instanceof ItemVaultTileEntity) {
            ((ItemVaultTileEntity)te).applyInventoryToBlock(this.handler);
            return;
        }
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        IItemHandler teHandler = (IItemHandler)capability.orElse(null);
        if (!(teHandler instanceof IItemHandlerModifiable)) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)teHandler;
        for (int slot = 0; slot < Math.min(inv.getSlots(), this.handler.getSlots()); ++slot) {
            inv.setStackInSlot(slot, this.handler.getStackInSlot(slot));
        }
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.handler;
    }

    public CompoundTag serialize() {
        if (!this.valid) {
            return null;
        }
        CompoundTag tag = this.handler.serializeNBT();
        if (this.noFuel) {
            NBTHelper.putMarker(tag, "NoFuel");
        }
        if (!(this.handler instanceof BottomlessItemHandler)) {
            return tag;
        }
        NBTHelper.putMarker(tag, "Bottomless");
        tag.m_128365_("ProvidedStack", (Tag)this.handler.getStackInSlot(0).serializeNBT());
        return tag;
    }

    public static MountedStorage deserialize(CompoundTag nbt) {
        MountedStorage storage = new MountedStorage(null);
        storage.handler = new ItemStackHandler();
        if (nbt == null) {
            return storage;
        }
        storage.valid = true;
        storage.noFuel = nbt.m_128441_("NoFuel");
        if (nbt.m_128441_("Bottomless")) {
            ItemStack providedStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ProvidedStack"));
            storage.handler = new BottomlessItemHandler(() -> providedStack);
            return storage;
        }
        storage.handler.deserializeNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean canUseForFuel() {
        return !this.noFuel;
    }
}

