/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkBearingTileEntity
extends KineticTileEntity
implements IBearingTileEntity,
IDisplayAssemblyExceptions {
    protected ControlledContraptionEntity hourHand;
    protected ControlledContraptionEntity minuteHand;
    protected float hourAngle;
    protected float minuteAngle;
    protected float clientHourAngleDiff;
    protected float clientMinuteAngleDiff;
    protected boolean running;
    protected boolean assembleNextTick;
    protected AssemblyException lastException;
    protected ScrollOptionBehaviour<ClockHands> operationMode;
    private float prevForcedAngle;

    public ClockworkBearingTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.operationMode = new ScrollOptionBehaviour<ClockHands>(ClockHands.class, (Component)Lang.translateDirect("contraptions.clockwork.clock_hands", new Object[0]), this, this.getMovementModeSlot());
        this.operationMode.requiresWrench();
        behaviours.add(this.operationMode);
        this.registerAwardables(behaviours, AllAdvancements.CLOCKWORK_BEARING);
    }

    @Override
    public boolean isWoodenTop() {
        return false;
    }

    @Override
    public void tick() {
        float newAngle;
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.prevForcedAngle = this.hourAngle;
            this.clientMinuteAngleDiff /= 2.0f;
            this.clientHourAngleDiff /= 2.0f;
        }
        if (!this.f_58857_.f_46443_ && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble = true;
                if (this.speed == 0.0f && (canDisassemble || this.hourHand == null || this.hourHand.getContraption().getBlocks().isEmpty())) {
                    if (this.hourHand != null) {
                        this.hourHand.getContraption().stop(this.f_58857_);
                    }
                    if (this.minuteHand != null) {
                        this.minuteHand.getContraption().stop(this.f_58857_);
                    }
                    this.disassemble();
                }
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.hourHand == null || !this.hourHand.isStalled()) {
            newAngle = this.hourAngle + this.getHourArmSpeed();
            this.hourAngle = newAngle % 360.0f;
        }
        if (this.minuteHand == null || !this.minuteHand.isStalled()) {
            newAngle = this.minuteAngle + this.getMinuteArmSpeed();
            this.minuteAngle = newAngle % 360.0f;
        }
        this.applyRotations();
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected void applyRotations() {
        BlockState blockState = this.m_58900_();
        Direction.Axis axis = Direction.Axis.X;
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            axis = ((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        if (this.hourHand != null) {
            this.hourHand.setAngle(this.hourAngle);
            this.hourHand.setRotationAxis(axis);
        }
        if (this.minuteHand != null) {
            this.minuteHand.setAngle(this.minuteAngle);
            this.minuteHand.setRotationAxis(axis);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.hourHand != null && !this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    public float getHourArmSpeed() {
        float speed = this.getAngularSpeed() / 2.0f;
        if (speed != 0.0f) {
            ClockHands mode = ClockHands.values()[this.operationMode.getValue()];
            float hourTarget = mode == ClockHands.HOUR_FIRST ? this.getHourTarget(false) : (mode == ClockHands.MINUTE_FIRST ? this.getMinuteTarget() : this.getHourTarget(true));
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.hourAngle, hourTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientHourAngleDiff / 3.0f;
    }

    public float getMinuteArmSpeed() {
        float speed = this.getAngularSpeed();
        if (speed != 0.0f) {
            ClockHands mode = ClockHands.values()[this.operationMode.getValue()];
            float minuteTarget = mode == ClockHands.MINUTE_FIRST ? this.getHourTarget(false) : this.getMinuteTarget();
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.minuteAngle, minuteTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientMinuteAngleDiff / 3.0f;
    }

    protected float getHourTarget(boolean cycle24) {
        boolean isNatural = this.f_58857_.m_6042_().m_63956_();
        int dayTime = (int)(this.f_58857_.m_46468_() * (long)(isNatural ? 1 : 24) % 24000L);
        int hours = (dayTime / 1000 + 6) % 24;
        int offset = ((Direction)this.m_58900_().m_61143_((Property)ClockworkBearingBlock.FACING)).m_122421_().m_122540_();
        float hourTarget = (float)(offset * -360) / (cycle24 ? 24.0f : 12.0f) * (float)(hours % (cycle24 ? 24 : 12));
        return hourTarget;
    }

    protected float getMinuteTarget() {
        boolean isNatural = this.f_58857_.m_6042_().m_63956_();
        int dayTime = (int)(this.f_58857_.m_46468_() * (long)(isNatural ? 1 : 24) % 24000L);
        int minutes = dayTime % 1000 * 60 / 1000;
        int offset = ((Direction)this.m_58900_().m_61143_((Property)ClockworkBearingBlock.FACING)).m_122421_().m_122540_();
        float minuteTarget = (float)(offset * -360) / 60.0f * (float)minutes;
        return minuteTarget;
    }

    public float getAngularSpeed() {
        float speed = -Math.abs(this.getSpeed() * 3.0f / 10.0f);
        if (this.f_58857_.f_46443_) {
            speed *= ServerSpeedProvider.get();
        }
        return speed;
    }

    public void assemble() {
        Pair<ClockworkContraption, ClockworkContraption> contraption;
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof ClockworkBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        try {
            contraption = ClockworkContraption.assembleClockworkAt(this.f_58857_, this.f_58858_, direction);
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption == null) {
            return;
        }
        if (contraption.getLeft() == null) {
            return;
        }
        if (((ClockworkContraption)contraption.getLeft()).getBlocks().isEmpty()) {
            return;
        }
        BlockPos anchor = this.f_58858_.m_142300_(direction);
        ((ClockworkContraption)contraption.getLeft()).removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.hourHand = ControlledContraptionEntity.create(this.f_58857_, this, (Contraption)contraption.getLeft());
        this.hourHand.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        this.hourHand.setRotationAxis(direction.m_122434_());
        this.f_58857_.m_7967_((Entity)this.hourHand);
        if (((ClockworkContraption)contraption.getLeft()).containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        if (contraption.getRight() != null) {
            anchor = this.f_58858_.m_5484_(direction, ((ClockworkContraption)contraption.getRight()).offset + 1);
            ((ClockworkContraption)contraption.getRight()).removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
            this.minuteHand = ControlledContraptionEntity.create(this.f_58857_, this, (Contraption)contraption.getRight());
            this.minuteHand.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
            this.minuteHand.setRotationAxis(direction.m_122434_());
            this.f_58857_.m_7967_((Entity)this.minuteHand);
            if (((ClockworkContraption)contraption.getRight()).containsBlockBreakers()) {
                this.award(AllAdvancements.CONTRAPTION_ACTORS);
            }
        }
        this.award(AllAdvancements.CLOCKWORK_BEARING);
        this.running = true;
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.sendData();
    }

    public void disassemble() {
        if (!this.running && this.hourHand == null && this.minuteHand == null) {
            return;
        }
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.applyRotations();
        if (this.hourHand != null) {
            this.hourHand.disassemble();
        }
        if (this.minuteHand != null) {
            this.minuteHand.disassemble();
        }
        this.hourHand = null;
        this.minuteHand = null;
        this.running = false;
        this.sendData();
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof ClockworkContraption)) {
            return;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption.getContraption();
        this.m_6596_();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos anchor = this.f_58858_.m_5484_(facing, cc.offset + 1);
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            this.hourHand = contraption;
            this.hourHand.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        } else {
            this.minuteHand = contraption;
            this.minuteHand.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        }
        if (!this.f_58857_.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128350_("HourAngle", this.hourAngle);
        compound.m_128350_("MinuteAngle", this.minuteAngle);
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        float hourAngleBefore = this.hourAngle;
        float minuteAngleBefore = this.minuteAngle;
        this.running = compound.m_128471_("Running");
        this.hourAngle = compound.m_128457_("HourAngle");
        this.minuteAngle = compound.m_128457_("MinuteAngle");
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            this.clientHourAngleDiff = AngleHelper.getShortestAngleDiff(hourAngleBefore, this.hourAngle);
            this.clientMinuteAngleDiff = AngleHelper.getShortestAngleDiff(minuteAngleBefore, this.minuteAngle);
            this.hourAngle = hourAngleBefore;
            this.minuteAngle = minuteAngleBefore;
        } else {
            this.hourHand = null;
            this.minuteHand = null;
        }
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    @Override
    public boolean isValid() {
        return !this.m_58901_();
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)partialTicks, (float)this.prevForcedAngle, (float)this.hourAngle);
        }
        if (this.hourHand == null || this.hourHand.isStalled()) {
            partialTicks = 0.0f;
        }
        return Mth.m_14179_((float)partialTicks, (float)this.hourAngle, (float)(this.hourAngle + this.getHourArmSpeed()));
    }

    @Override
    public void onStall() {
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    @Override
    public void remove() {
        if (!this.f_58857_.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof ClockworkContraption)) {
            return false;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption.getContraption();
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            return this.hourHand == contraption;
        }
        return this.minuteHand == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.f_58858_;
    }

    @Override
    public void setAngle(float forcedAngle) {
        this.hourAngle = forcedAngle;
    }

    static enum ClockHands implements INamedIconOptions
    {
        HOUR_FIRST(AllIcons.I_HOUR_HAND_FIRST),
        MINUTE_FIRST(AllIcons.I_MINUTE_HAND_FIRST),
        HOUR_FIRST_24(AllIcons.I_HOUR_HAND_FIRST_24);

        private String translationKey;
        private AllIcons icon;

        private ClockHands(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.clockwork." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

