/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SpeedGaugeTileEntity
extends GaugeTileEntity {
    public SpeedGaugeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.abs(this.getSpeed());
        this.dialTarget = SpeedGaugeTileEntity.getDialTarget(speed);
        this.color = Color.mixColors(IRotate.SpeedLevel.of(speed).getColor(), 0xFFFFFF, 0.25f);
        this.m_6596_();
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get()).floatValue();
        float target = 0.0f;
        target = speed == 0.0f ? 0.0f : (speed < medium ? Mth.m_14179_((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? Mth.m_14179_((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : Mth.m_14179_((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        Lang.translate("gui.speedometer.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText(this.speed, this.isOverStressed()).forGoggles(tooltip);
        return true;
    }
}

