/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.deco;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.curiosities.deco.SlidingDoorTileEntity;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.CarriageSyncData;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SlidingDoorMovementBehaviour
implements MovementBehaviour {
    @Override
    public boolean renderAsNormalTileEntity() {
        return true;
    }

    @Override
    public void tick(MovementContext context) {
        Map<BlockPos, BlockEntity> tes;
        BlockEntity blockEntity;
        StructureTemplate.StructureBlockInfo structureBlockInfo = context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = SlidingDoorTileEntity.isOpen(structureBlockInfo.f_74676_);
        if (!context.world.m_5776_()) {
            this.tickOpen(context, open);
        }
        if (!((blockEntity = (tes = context.contraption.presentTileEntities).get(context.localPos)) instanceof SlidingDoorTileEntity)) {
            return;
        }
        SlidingDoorTileEntity doorTE = (SlidingDoorTileEntity)blockEntity;
        boolean wasSettled = doorTE.animation.settled();
        doorTE.animation.chase(open ? 1.0 : 0.0, 0.15f, LerpedFloat.Chaser.LINEAR);
        doorTE.animation.tickChaser();
        if (!wasSettled && doorTE.animation.settled() && !open) {
            context.world.m_7785_(context.position.f_82479_, context.position.f_82480_, context.position.f_82481_, SoundEvents.f_12055_, SoundSource.BLOCKS, 0.125f, 1.0f, false);
        }
    }

    protected void tickOpen(MovementContext context, boolean currentlyOpen) {
        boolean shouldOpen = this.shouldOpen(context);
        if (!this.shouldUpdate(context, shouldOpen)) {
            return;
        }
        if (currentlyOpen == shouldOpen) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(pos);
        if (info == null || !info.f_74676_.m_61138_((Property)DoorBlock.f_52727_)) {
            return;
        }
        this.toggleDoor(pos, contraption, info);
        if (shouldOpen) {
            context.world.m_5594_(null, new BlockPos(context.position), SoundEvents.f_12056_, SoundSource.BLOCKS, 0.125f, 1.0f);
        }
    }

    private void toggleDoor(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.f_74676_.m_61122_((Property)DoorBlock.f_52727_);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.f_74675_, newState, info.f_74677_));
        BlockPos otherPos = newState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        info = contraption.getBlocks().get(otherPos);
        if (info != null && info.f_74676_.m_61138_((Property)DoorBlock.f_52727_)) {
            newState = (BlockState)info.f_74676_.m_61122_((Property)DoorBlock.f_52727_);
            contraption.entity.setBlock(otherPos, new StructureTemplate.StructureBlockInfo(info.f_74675_, newState, info.f_74677_));
            contraption.invalidateColliders();
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldOpen) {
        if (context.firstMovement && shouldOpen) {
            return false;
        }
        if (!context.data.m_128441_("Open")) {
            context.data.m_128379_("Open", shouldOpen);
            return true;
        }
        boolean wasOpen = context.data.m_128471_("Open");
        context.data.m_128379_("Open", shouldOpen);
        return wasOpen != shouldOpen;
    }

    protected boolean shouldOpen(MovementContext context) {
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (abstractContraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
            CarriageSyncData carriageData = cce.getCarriageData();
            if (Math.abs(carriageData.distanceToDestination) > 1.0f) {
                return false;
            }
        }
        return context.motion.m_82553_() < 0.0078125 && !context.contraption.entity.isStalled();
    }
}

