/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchScreen;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;

public class StockpileSwitchBlock
extends HorizontalDirectionalBlock
implements ITE<StockpileSwitchTileEntity>,
IWrenchable {
    public static final IntegerProperty INDICATOR = IntegerProperty.m_61631_((String)"indicator", (int)0, (int)6);

    public StockpileSwitchBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateObservedInventory(state, (LevelReader)worldIn, pos);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.STOCKPILE_SWITCH.get((Direction)state.m_61143_((Property)f_54117_));
    }

    private void updateObservedInventory(BlockState state, LevelReader world, BlockPos pos) {
        this.withTileEntityDo((BlockGetter)world, pos, StockpileSwitchTileEntity::updateCurrentLevel);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && side.m_122424_() != state.m_61143_((Property)f_54117_);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side == ((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_()) {
            return 0;
        }
        return this.getTileEntityOptional(blockAccess, pos).filter(StockpileSwitchTileEntity::isPowered).map($ -> 15).orElse(0);
    }

    public void m_7458_(BlockState blockState, ServerLevel world, BlockPos pos, Random random) {
        this.getTileEntityOptional((BlockGetter)world, pos).ifPresent(StockpileSwitchTileEntity::updatePowerAfterDelay);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, INDICATOR});
        super.m_7926_(builder);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player != null && AllItems.WRENCH.isIn(player.m_21120_(handIn))) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withTileEntityDo((BlockGetter)worldIn, pos, te -> this.displayScreen((StockpileSwitchTileEntity)te, player)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(StockpileSwitchTileEntity te, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open(new StockpileSwitchScreen(te));
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Capability itemCap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        Capability fluidCap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        Direction preferredFacing = null;
        for (Direction face : Iterate.horizontalDirections) {
            BlockEntity te = context.m_43725_().m_7702_(context.m_8083_().m_142300_(face));
            if (te == null || !te.getCapability(itemCap).isPresent() && !te.getCapability(fluidCap).isPresent()) continue;
            if (preferredFacing == null) {
                preferredFacing = face;
                continue;
            }
            preferredFacing = null;
            break;
        }
        if (preferredFacing != null) {
            return (BlockState)state.m_61124_((Property)f_54117_, preferredFacing);
        }
        Direction facing = context.m_43719_().m_122434_().m_122479_() ? context.m_43719_() : context.m_8125_().m_122424_();
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)(context.m_43723_() != null && context.m_43723_().m_20161_() ? facing.m_122424_() : facing));
    }

    @Override
    public Class<StockpileSwitchTileEntity> getTileEntityClass() {
        return StockpileSwitchTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends StockpileSwitchTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.STOCKPILE_SWITCH.get();
    }
}

