/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.packet;

import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SchematicPlacePacket
extends SimplePacketBase {
    public ItemStack stack;

    public SchematicPlacePacket(ItemStack stack) {
        this.stack = stack;
    }

    public SchematicPlacePacket(FriendlyByteBuf buffer) {
        this.stack = buffer.m_130267_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.stack);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel world = player.m_183503_();
            SchematicPrinter printer = new SchematicPrinter();
            printer.loadSchematic(this.stack, (Level)world, !player.m_36337_());
            if (!printer.isLoaded() || printer.isErrored()) {
                return;
            }
            boolean includeAir = (Boolean)AllConfigs.SERVER.schematics.creativePrintIncludesAir.get();
            while (printer.advanceCurrentPos()) {
                if (!printer.shouldPlaceCurrent((Level)world)) continue;
                printer.handleCurrentTarget((arg_0, arg_1, arg_2) -> SchematicPlacePacket.lambda$handle$0(includeAir, (Level)world, arg_0, arg_1, arg_2), (arg_0, arg_1) -> SchematicPlacePacket.lambda$handle$1((Level)world, arg_0, arg_1));
            }
        });
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(Level world, BlockPos pos, Entity entity) {
        world.m_7967_(entity);
    }

    private static /* synthetic */ void lambda$handle$0(boolean includeAir, Level world, BlockPos pos, BlockState state, BlockEntity tile) {
        boolean placingAir = state.m_60795_();
        if (placingAir && !includeAir) {
            return;
        }
        CompoundTag tileData = tile != null ? tile.m_187480_() : null;
        BlockHelper.placeSchematicBlock(world, state, pos, null, tileData);
    }
}

