/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change.changes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.change.changes.BitChange;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.Validate;

public class CombinedChange
implements IChange {
    private final Collection<IChange> changes;

    public CombinedChange(Collection<IChange> changes) {
        this.changes = changes;
    }

    public CombinedChange(Tag tag) {
        Validate.isInstanceOf(CompoundTag.class, (Object)tag);
        this.changes = new ArrayList<IChange>();
        this.deserializeNBT((CompoundTag)tag);
    }

    @Override
    public boolean canUndo(Player player) {
        for (IChange change : this.changes) {
            if (change.canUndo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRedo(Player player) {
        for (IChange change : this.changes) {
            if (change.canRedo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void undo(Player player) throws IllegalChangeAttempt {
        for (IChange change : this.changes) {
            change.undo(player);
        }
    }

    @Override
    public void redo(Player player) throws IllegalChangeAttempt {
        for (IChange change : this.changes) {
            change.redo(player);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("changes", (Tag)this.changes.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(ListTag::new)));
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ListTag tag = nbt.m_128437_("changes", 10);
        this.changes.clear();
        this.changes.addAll(tag.stream().map(BitChange::new).collect(Collectors.toList()));
    }
}

